/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.math.BigDecimal;
import java.util.List;
import org.geolatte.geom.codec.db.oracle.CompoundIElemInfoTriplet;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.SimpleIElemInfoTriplet;

abstract class ElemInfoTriplet {
    private final int startingOffset;
    private final ElementType elementType;

    static ElemInfoTriplet parse(BigDecimal[] triplet) {
        int interp;
        int sOffset = triplet[0].intValue();
        int etype = triplet[1].intValue();
        ElementType et = ElementType.parseType(etype, interp = triplet[2].intValue());
        if (et.isCompound()) {
            return new CompoundIElemInfoTriplet(sOffset, et);
        }
        return new SimpleIElemInfoTriplet(sOffset, et);
    }

    ElemInfoTriplet(int sOffset, ElementType et) {
        this.startingOffset = sOffset;
        this.elementType = et;
    }

    int getStartingOffset() {
        return this.startingOffset;
    }

    abstract boolean isSimple();

    abstract boolean isCompound();

    ElementType getElementType() {
        return this.elementType;
    }

    abstract ElemInfoTriplet shiftStartingOffset(int var1);

    void addTo(List<BigDecimal> list) {
        list.add(BigDecimal.valueOf(this.startingOffset));
        list.add(BigDecimal.valueOf(this.elementType.getEType()));
        list.add(BigDecimal.valueOf(this.elementType.getInterpretation()));
    }
}

