/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.AbstractGeometryCollection;
import org.geolatte.geom.C2D;
import org.geolatte.geom.ExactPositionEquality;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryOperation;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineSegment;
import org.geolatte.geom.LineSegments;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MeasureGeometryOperations;
import org.geolatte.geom.MeasureInterpolatingVisitor;
import org.geolatte.geom.Measured;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionEquality;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.PositionVisitor;
import org.geolatte.geom.Vector;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.Unit;

public class DefaultMeasureGeometryOperations
implements MeasureGeometryOperations {
    private static final PositionEquality pntEq = new ExactPositionEquality();

    @Override
    public <P extends C2D> Geometry<P> locateAlong(Geometry<P> geometry, double mValue) {
        return this.locateBetween(geometry, mValue, mValue);
    }

    @Override
    public <P extends C2D> Geometry<P> locateBetween(Geometry<P> geometry, double startMeasure, double endMeasure) {
        if (geometry == null) {
            throw new IllegalArgumentException("Null geometries not allowed.");
        }
        if (geometry.isEmpty()) {
            return new Point<P>(geometry.getCoordinateReferenceSystem());
        }
        if (C2D.class.isAssignableFrom(geometry.getPositionClass()) && Measured.class.isAssignableFrom(geometry.getPositionClass())) {
            MeasureInterpolatingVisitor<P> visitor = new MeasureInterpolatingVisitor<P>(geometry, startMeasure, endMeasure);
            geometry.accept(visitor);
            return visitor.result();
        }
        throw new IllegalArgumentException("Requires projected coordinates");
    }

    @Override
    public <P extends C2D> double measureAt(Geometry<P> geometry, C2D pos, double tolerance) {
        if (geometry == null || pos == null) {
            throw new IllegalArgumentException("Parameters must not be NULL");
        }
        if (geometry.isEmpty()) {
            return Double.NaN;
        }
        InterpolatingVisitor visitor = new InterpolatingVisitor(pos, tolerance);
        geometry.accept(visitor);
        return visitor.m();
    }

    @Override
    public <P extends C2D, M extends C2D> Geometry<M> measureOnLength(Geometry<P> geometry, Class<M> positionTypeMarker, boolean keepBeginMeasure) {
        CoordinateReferenceSystem measuredVariant;
        if (geometry == null) {
            throw new IllegalArgumentException("Geometry parameter must not be NULL");
        }
        if (positionTypeMarker == null) {
            throw new IllegalArgumentException("PositionTypeMarker parameter must not be NULL");
        }
        if (geometry.getGeometryType() != GeometryType.LINESTRING && geometry.getGeometryType() != GeometryType.MULTILINESTRING) {
            throw new IllegalArgumentException("Geometry parameter must be of type LineString or MultiLineString");
        }
        CoordinateReferenceSystem sourceCRS = geometry.getCoordinateReferenceSystem();
        CoordinateReferenceSystem coordinateReferenceSystem = measuredVariant = !CoordinateReferenceSystems.hasMeasureAxis(sourceCRS) ? CoordinateReferenceSystems.addLinearSystem(sourceCRS, Unit.METER) : sourceCRS;
        if (!measuredVariant.getPositionClass().equals(positionTypeMarker)) {
            throw new IllegalArgumentException(String.format("Inconsistent types: measured CRS has position type %s,  but positionTypeMarker is %s.", measuredVariant.getPositionClass().getName(), positionTypeMarker.getName()));
        }
        return new OnLengthMeasureOp<P>(geometry, measuredVariant, keepBeginMeasure).execute();
    }

    @Override
    public <P extends Position> double minimumMeasure(Geometry<P> geometry) {
        return this.createGetExtrMeasureOp(geometry, true).execute();
    }

    @Override
    public <P extends Position> double maximumMeasure(Geometry<P> geometry) {
        return this.createGetExtrMeasureOp(geometry, false).execute();
    }

    private <P extends Position> GeometryOperation<Double> createGetExtrMeasureOp(final Geometry<P> geometry, final boolean min) {
        return new GeometryOperation<Double>(){

            @Override
            public Double execute() {
                if (geometry == null) {
                    throw new IllegalArgumentException("Operation expects a non-empty geometry");
                }
                if (geometry.isEmpty()) {
                    return Double.NaN;
                }
                FindExtremumMeasureVisitor visitor = new FindExtremumMeasureVisitor(min);
                geometry.getPositions().accept(visitor);
                return visitor.extremum;
            }
        };
    }

    private static class OnLengthMeasureOp<M extends C2D>
    implements GeometryOperation<Geometry<M>> {
        private double length = 0.0;
        private final Geometry<?> geometry;
        private final CoordinateReferenceSystem<M> measuredVariant;
        private final boolean keepBeginMeasure;

        OnLengthMeasureOp(Geometry<?> geometry, CoordinateReferenceSystem<M> measuredVariant, boolean keepBeginMeasure) {
            this.geometry = geometry;
            this.measuredVariant = measuredVariant;
            this.keepBeginMeasure = keepBeginMeasure;
        }

        @Override
        public Geometry<M> execute() {
            Geometry<M> measured = Geometry.forceToCrs(this.geometry, this.measuredVariant);
            if (measured.isEmpty()) {
                return measured;
            }
            if (this.keepBeginMeasure) {
                double initialValue = ((Measured)((Object)((C2D)measured.getPositionN(0)))).getM();
                double d = this.length = Double.isNaN(initialValue) ? 0.0 : initialValue;
            }
            if (measured instanceof LineString) {
                return this.measure((LineString)measured);
            }
            if (this.geometry instanceof MultiLineString) {
                return this.measure((MultiLineString)measured);
            }
            throw new IllegalStateException(String.format("Requires a LineString or MultiLineString, but received %s", this.geometry.getClass().getName()));
        }

        private <T extends C2D> MultiLineString<T> measure(MultiLineString<T> geometry) {
            LineString[] measuredParts = new LineString[geometry.getNumGeometries()];
            for (int part = 0; part < geometry.getNumGeometries(); ++part) {
                LineString lineString = (LineString)geometry.getGeometryN(part);
                measuredParts[part] = this.measure(lineString);
            }
            return new MultiLineString(measuredParts);
        }

        private <T extends C2D> LineString<T> measure(LineString<T> geometry) {
            CoordinateReferenceSystem crs = geometry.getCoordinateReferenceSystem();
            PositionSequence originalPoints = geometry.getPositions();
            PositionSequenceBuilder<double[]> builder = PositionSequenceBuilders.fixedSized(originalPoints.size(), geometry.getPositionClass());
            int mIdx = CoordinateReferenceSystems.hasVerticalAxis(crs) ? 3 : 2;
            double[] coordinates = new double[geometry.getCoordinateDimension()];
            double[] prevCoordinates = new double[geometry.getCoordinateDimension()];
            for (int i = 0; i < originalPoints.size(); ++i) {
                originalPoints.getCoordinates(i, coordinates);
                if (i > 0) {
                    this.length += Math.hypot(coordinates[0] - prevCoordinates[0], coordinates[1] - prevCoordinates[1]);
                }
                coordinates[mIdx] = this.length;
                builder.add(coordinates);
                prevCoordinates[0] = coordinates[0];
                prevCoordinates[1] = coordinates[1];
            }
            return new LineString(builder.toPositionSequence(), crs);
        }
    }

    private static class FindExtremumMeasureVisitor<P extends Position>
    implements PositionVisitor<P> {
        final boolean findMinimum;
        double extremum;

        FindExtremumMeasureVisitor(boolean minimum) {
            this.findMinimum = minimum;
            this.extremum = minimum ? Double.MAX_VALUE : Double.MIN_VALUE;
        }

        @Override
        public void visit(P position) {
            double m = ((Measured)position).getM();
            this.extremum = this.findMinimum ? (m < this.extremum ? m : this.extremum) : (m > this.extremum ? m : this.extremum);
        }
    }

    private static class InterpolatingVisitor<P extends C2D>
    implements GeometryVisitor<P> {
        public static final String INVALID_TYPE_MSG = "Operation only valid on LineString, MultiPoint and MultiLineString Geometries.";
        public static final String OUTSIDE_TOL_MSG = "Search point not within tolerance: distance to geometry is %f > %f";
        final C2D searchPosition;
        final double tolerance;
        double mValue = Double.NaN;
        double distToSearchPoint = Double.MAX_VALUE;

        InterpolatingVisitor(C2D pnt, double tolerance) {
            if (pnt == null) {
                throw new IllegalArgumentException("Null point is not allowed.");
            }
            this.searchPosition = pnt;
            this.tolerance = Math.abs(tolerance);
        }

        double m() {
            if (this.distToSearchPoint <= this.tolerance) {
                return this.mValue;
            }
            throw new IllegalArgumentException(String.format(OUTSIDE_TOL_MSG, this.distToSearchPoint, this.tolerance));
        }

        @Override
        public void visit(Point<P> point) {
            C2D pos = (C2D)point.getPosition();
            double dts = Math.hypot(pos.getX() - this.searchPosition.getX(), pos.getY() - this.searchPosition.getY());
            if (dts <= this.distToSearchPoint) {
                this.mValue = ((Measured)((Object)((C2D)point.getPosition()))).getM();
                this.distToSearchPoint = dts;
            }
        }

        @Override
        public void visit(LineString<P> lineString) {
            LineSegments lineSegments = new LineSegments(lineString.getPositions());
            for (LineSegment segment : lineSegments) {
                C2D p1;
                C2D p0 = (C2D)segment.getStartPosition();
                double[] dAndR = Vector.positionToSegment2D(p0, p1 = (C2D)segment.getEndPosition(), this.searchPosition);
                double d = Math.sqrt(dAndR[0]);
                if (!(d <= this.distToSearchPoint)) continue;
                double r = dAndR[1];
                this.mValue = r <= 0.0 ? ((Measured)((Object)p0)).getM() : (r >= 1.0 ? ((Measured)((Object)p1)).getM() : ((Measured)((Object)p0)).getM() + r * (((Measured)((Object)p1)).getM() - ((Measured)((Object)p0)).getM()));
                this.distToSearchPoint = d;
            }
        }

        @Override
        public void visit(Polygon<P> polygon) {
            throw new IllegalArgumentException(INVALID_TYPE_MSG);
        }

        @Override
        public <G extends Geometry<P>> void visit(AbstractGeometryCollection<P, G> collection) {
        }
    }
}

