/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Collections;
import java.util.List;
import org.geolatte.geom.C2D;
import org.geolatte.geom.crs.CartesianCoordinateSystem2D;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.Extension;
import org.geolatte.geom.crs.Geographic2DCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;
import org.geolatte.geom.crs.SingleCoordinateReferenceSystem;

public class ProjectedCoordinateReferenceSystem
extends SingleCoordinateReferenceSystem<C2D> {
    private final Projection projection;
    private final Geographic2DCoordinateReferenceSystem geoCRS;
    private final List<CrsParameter> parameters;
    private final Extension extension;

    public ProjectedCoordinateReferenceSystem(CrsId crsId, String name, Geographic2DCoordinateReferenceSystem geoCRS, Projection projection, List<CrsParameter> parameters, CartesianCoordinateSystem2D crs) {
        this(crsId, name, geoCRS, projection, parameters, crs, null);
    }

    public ProjectedCoordinateReferenceSystem(CrsId crsId, String name, Geographic2DCoordinateReferenceSystem geoCRS, Projection projection, List<CrsParameter> parameters, CartesianCoordinateSystem2D crs, Extension extension) {
        super(crsId, name, crs);
        this.geoCRS = geoCRS;
        this.projection = projection;
        this.parameters = parameters;
        this.extension = extension;
    }

    public List<CrsParameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Geographic2DCoordinateReferenceSystem getGeographicCoordinateSystem() {
        return this.geoCRS;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Extension getExtension() {
        return this.extension;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectedCoordinateReferenceSystem that = (ProjectedCoordinateReferenceSystem)o;
        if (!this.geoCRS.equals(that.geoCRS)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        return this.projection.equals(that.projection);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.projection.hashCode();
        result = 31 * result + this.geoCRS.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }
}

