/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.codec.db.oracle.TypeGeometry;

class SDOGType {
    private int dimension = 2;
    private int lrsDimension;
    private TypeGeometry typeGeometry = TypeGeometry.UNKNOWN_GEOMETRY;

    public SDOGType(int dimension, int lrsDimension, TypeGeometry typeGeometry) {
        this.setDimension(dimension);
        this.setLrsDimension(lrsDimension);
        this.setTypeGeometry(typeGeometry);
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        if (dimension < 2 || dimension > 4) {
            throw new IllegalArgumentException("Dimension can only be 2,3 or 4.");
        }
        this.dimension = dimension;
    }

    public TypeGeometry getTypeGeometry() {
        return this.typeGeometry;
    }

    public void setTypeGeometry(TypeGeometry typeGeometry) {
        this.typeGeometry = typeGeometry;
    }

    public int getLRSDimension() {
        if (this.lrsDimension > 0) {
            return this.lrsDimension;
        }
        if (this.lrsDimension == 0 && this.dimension == 4) {
            return 4;
        }
        return 0;
    }

    public int getZDimension() {
        if (this.getLRSDimension() == 3 && this.dimension == 3) {
            return -1;
        }
        if (this.getLRSDimension() == 3 && this.dimension == 4) {
            return 4;
        }
        if (this.getLRSDimension() == 4 && this.dimension == 4) {
            return 3;
        }
        return this.dimension > 2 ? 3 : -1;
    }

    public boolean isLRSGeometry() {
        return this.getLRSDimension() > 0;
    }

    public void setLrsDimension(int lrsDimension) {
        if (lrsDimension != 0 && lrsDimension > this.dimension) {
            throw new IllegalArgumentException("lrsDimension must be 0 or lower or equal to dimenstion.");
        }
        this.lrsDimension = lrsDimension;
    }

    public int intValue() {
        int v = this.dimension * 1000;
        v += this.lrsDimension * 100;
        return v += this.typeGeometry.intValue();
    }

    public static SDOGType parse(int v) {
        int dim = v / 1000;
        int lrsDim = (v -= dim * 1000) / 100;
        TypeGeometry typeGeometry = TypeGeometry.parse(v -= lrsDim * 100);
        return new SDOGType(dim, lrsDim, typeGeometry);
    }

    public static SDOGType parse(Object datum) {
        try {
            int v = ((Number)datum).intValue();
            return SDOGType.parse(v);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDOGType sdogType = (SDOGType)o;
        if (this.dimension != sdogType.dimension) {
            return false;
        }
        if (this.lrsDimension != sdogType.lrsDimension) {
            return false;
        }
        return this.typeGeometry == sdogType.typeGeometry;
    }

    public int hashCode() {
        int result = this.dimension;
        result = 31 * result + this.lrsDimension;
        result = 31 * result + (this.typeGeometry != null ? this.typeGeometry.hashCode() : 0);
        return result;
    }
}

