/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class PolygonSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == TypeGeometry.POLYGON;
    }

    @Override
    Geometry<?> internalDecode(SDOGeometry sdoGeom) {
        int numCompounds;
        CoordinateReferenceSystem<?> crs = this.getCoordinateReferenceSystem(sdoGeom);
        Object shell = null;
        LinearRing[] rings = new LinearRing[sdoGeom.getNumElements()];
        ElemInfo info = sdoGeom.getInfo();
        int idxInteriorRings = 1;
        for (int i = 0; i < info.getSize(); i += 1 + numCompounds) {
            PositionSequence<?> cs = null;
            numCompounds = 0;
            if (info.getElementType(i).isCompound()) {
                numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, sdoGeom));
            } else {
                cs = this.add(cs, this.getElementCSeq(i, sdoGeom, false, crs));
            }
            if (info.getElementType(i).isInteriorRing()) {
                rings[idxInteriorRings] = new LinearRing(cs, crs);
                ++idxInteriorRings;
                continue;
            }
            rings[0] = new LinearRing(cs, crs);
        }
        return new Polygon(rings);
    }
}

