/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MultiLineSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == TypeGeometry.MULTILINE;
    }

    @Override
    Geometry<?> internalDecode(SDOGeometry sdoGeom) {
        CoordinateReferenceSystem<?> crs = this.getCoordinateReferenceSystem(sdoGeom);
        ElemInfo info = sdoGeom.getInfo();
        LineString[] lines = new LineString[sdoGeom.getInfo().getSize()];
        int i = 0;
        while (i < info.getSize()) {
            LineString line;
            PositionSequence<?> cs = null;
            if (info.getElementType(i).isCompound()) {
                LineString line2;
                int numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, sdoGeom));
                lines[i] = line2 = new LineString(cs, crs);
                i += 1 + numCompounds;
                continue;
            }
            cs = this.add(cs, this.getElementCSeq(i, sdoGeom, false, crs));
            lines[i] = line = new LineString(cs, crs);
            ++i;
        }
        return new MultiLineString(lines);
    }
}

