/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.codec.AbstractWktTokenizer;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.codec.WktPointSequenceToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.Unit;

class WktTokenizer
extends AbstractWktTokenizer {
    private boolean isMeasured = false;
    protected final CoordinateReferenceSystem<?> baseCRS;
    protected final boolean forceToCRS;
    private CoordinateReferenceSystem<?> targetCRS;
    private static long S_MAX = 0x1FFFFFFFFFFFFFL;
    private static long P_MAX = 22L;

    protected WktTokenizer(CharSequence wkt, WktVariant variant, CoordinateReferenceSystem<?> baseCRS, boolean forceToCRS) {
        super(wkt, variant);
        if (wkt == null || variant == null) {
            throw new IllegalArgumentException("Input WKT and variant must not be null");
        }
        if (baseCRS == null) {
            this.baseCRS = CoordinateReferenceSystems.PROJECTED_2D_METER;
            this.forceToCRS = false;
        } else {
            this.baseCRS = baseCRS;
            this.forceToCRS = forceToCRS;
        }
    }

    protected WktTokenizer(CharSequence wkt, WktVariant variant, CoordinateReferenceSystem<?> baseCRS) {
        this(wkt, variant, baseCRS, false);
    }

    @Override
    WktToken numericToken() {
        CoordinateReferenceSystem<?> crs = this.getCoordinateReferenceSystem();
        int numPoints = this.countPoints();
        double[] coords = new double[crs.getCoordinateDimension()];
        PositionSequenceBuilder<?> psBuilder = PositionSequenceBuilders.fixedSized(numPoints, crs.getPositionClass());
        for (int i = 0; i < numPoints; ++i) {
            this.readPoint(coords);
            psBuilder.add(coords);
            this.skipPointDelimiter();
        }
        return new WktPointSequenceToken(psBuilder.toPositionSequence(), this.getCoordinateReferenceSystem());
    }

    private void readPoint(double[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = this.fastReadNumber();
        }
    }

    protected double fastReadNumber() {
        this.skipWhitespace();
        int startPos = this.currentPos;
        char c = this.wkt.charAt(this.currentPos);
        double sign = 1.0;
        if (c == '-') {
            sign = -1.0;
            c = this.wkt.charAt(++this.currentPos);
        }
        long s = 0L;
        boolean decPntSeen = false;
        long decPos = -1L;
        while (true) {
            if (Character.isDigit(c)) {
                s = 10L * s + (long)(c - 48);
            } else {
                if (c != '.') break;
                if (decPntSeen) {
                    throw new WktDecodeException("Invalid number format at position " + this.currentPos);
                }
                decPntSeen = true;
            }
            if (decPntSeen) {
                ++decPos;
            }
            c = this.wkt.charAt(++this.currentPos);
        }
        long exp = 0L;
        long expSign = 1L;
        if (c == 'e' || c == 'E') {
            if ((c = this.wkt.charAt(++this.currentPos)) == '-') {
                expSign = -1L;
                c = this.wkt.charAt(++this.currentPos);
            }
            while (Character.isDigit(c)) {
                exp = 10L * exp + (long)(c - 48);
                c = this.wkt.charAt(++this.currentPos);
            }
        }
        long p = decPos >= 0L ? expSign * exp - decPos : expSign * exp;
        int endPos = this.currentPos;
        return this.toDouble(sign, s, p, startPos, endPos);
    }

    private int countPoints() {
        int pos = this.currentPos + 1;
        char c = this.wkt.charAt(pos);
        int num = 1;
        while (c != ')') {
            if (c == ',') {
                ++num;
            }
            c = this.wkt.charAt(++pos);
        }
        return num;
    }

    private CoordinateReferenceSystem<?> getCoordinateReferenceSystem() {
        if (this.targetCRS == null) {
            this.targetCRS = this.determineTargetCRS();
        }
        return this.targetCRS;
    }

    private CoordinateReferenceSystem<?> determineTargetCRS() {
        int pos = this.currentPos;
        int num = 1;
        boolean inNumber = true;
        char c = this.wkt.charAt(pos);
        while (c != ',' && c != this.variant.getCloseListChar()) {
            if (!Character.isDigit(c) && c != '.' && c != '-' && c != 'e' && c != 'E') {
                inNumber = false;
            } else if (!inNumber) {
                ++num;
                inNumber = true;
            }
            if (pos == this.wkt.length() - 1) {
                throw new WktDecodeException("");
            }
            c = this.wkt.charAt(++pos);
        }
        if (num == 4) {
            return this.ensureZM(this.baseCRS, true, true);
        }
        if (num == 3 && this.isMeasured) {
            return this.ensureZM(this.baseCRS, false, true);
        }
        if (num == 3 && !this.isMeasured) {
            return this.ensureZM(this.baseCRS, true, false);
        }
        if (num == 2) {
            return this.baseCRS;
        }
        throw new WktDecodeException("Point with less than 2 coordinates at position " + this.currentPos);
    }

    private CoordinateReferenceSystem<?> ensureZM(CoordinateReferenceSystem<?> crs, boolean needZ, boolean needM) {
        CoordinateReferenceSystem<?> compound = crs;
        if (needZ && !CoordinateReferenceSystems.hasVerticalAxis(compound)) {
            compound = CoordinateReferenceSystems.addVerticalSystem(compound, Unit.METER);
        }
        if (needM && !CoordinateReferenceSystems.hasMeasureAxis(compound)) {
            compound = CoordinateReferenceSystems.addLinearSystem(compound, Unit.METER);
        }
        if (this.forceToCRS && !compound.equals(crs)) {
            throw new WktDecodeException("WKT inconsistent with specified Coordinate Reference System");
        }
        return compound;
    }

    private void skipPointDelimiter() {
        this.skipWhitespace();
        if (this.wkt.charAt(this.currentPos) == ',') {
            ++this.currentPos;
        }
    }

    @Override
    protected WktToken matchKeyword(int currentPos, int endPos) {
        WktKeywordToken token = this.variant.matchKeyword(this.wkt, currentPos, endPos);
        if (token instanceof WktGeometryToken) {
            this.isMeasured = this.isMeasured || ((WktGeometryToken)token).isMeasured();
        }
        return token;
    }

    protected double toDouble(double sign, long s, long p, int startPos, int endPos) {
        if (s == 0L) {
            return 0.0;
        }
        if (s > 0L && s <= S_MAX && Math.abs(p) <= P_MAX) {
            if (p == 0L) {
                return sign * (double)s;
            }
            if (p < 0L) {
                return sign * ((double)s / Math.pow(10.0, -p));
            }
            return sign * ((double)s * Math.pow(10.0, p));
        }
        return Double.parseDouble(this.wkt.subSequence(startPos, endPos).toString());
    }
}

