/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.builder;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.geolatte.geom.C2D;
import org.geolatte.geom.C2DM;
import org.geolatte.geom.C3D;
import org.geolatte.geom.C3DM;
import org.geolatte.geom.G2D;
import org.geolatte.geom.G2DM;
import org.geolatte.geom.G3D;
import org.geolatte.geom.G3DM;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class DSL {
    private DSL() {
    }

    public static C2D c(double x, double y) {
        return new C2D(x, y);
    }

    public static C3D c(double x, double y, double z) {
        return new C3D(x, y, z);
    }

    public static C2DM cM(double x, double y, double m) {
        return new C2DM(x, y, m);
    }

    public static C3DM c(double x, double y, double z, double m) {
        return new C3DM(x, y, z, m);
    }

    public static G2D g(double lon, double lat) {
        return new G2D(lon, lat);
    }

    public static G3D g(double lon, double lat, double height) {
        return new G3D(lon, lat, height);
    }

    public static G2DM gM(double lon, double lat, double m) {
        return new G2DM(lon, lat, m);
    }

    public static G3DM g(double lon, double lat, double height, double m) {
        return new G3DM(lon, lat, height, m);
    }

    public static <P extends Position> Point<P> point(CoordinateReferenceSystem<P> crs, P p) {
        return new Point<P>(p, crs);
    }

    public static <P extends Position> PointToken<P> point(P position) {
        return new PointToken<P>(position);
    }

    public static <P extends Position> LineString<P> linestring(CoordinateReferenceSystem<P> crs, P ... positions) {
        return new LineString<P>(DSL.toSeq(crs, positions), crs);
    }

    public static <P extends Position> LineStringToken<P> linestring(P ... positions) {
        return new LineStringToken(positions);
    }

    public static <P extends Position> LinearRing<P> ring(CoordinateReferenceSystem<P> crs, P ... positions) {
        return new LinearRing<P>(DSL.toSeq(crs, positions), crs);
    }

    @SafeVarargs
    public static <P extends Position> LinearRingToken<P> ring(P ... positions) {
        return new LinearRingToken(positions);
    }

    @SafeVarargs
    private static <P extends Position, G extends Geometry<P>> G[] combine(Class<G> resultType, G geometry, G ... geometries) {
        Object[] allGeometries = (Object[])Array.newInstance(resultType, geometries.length + 1);
        allGeometries[0] = geometry;
        System.arraycopy(geometries, 0, allGeometries, 1, geometries.length);
        return (Geometry[])allGeometries;
    }

    @SafeVarargs
    public static <P extends Position> GeometryCollection<P, Geometry<P>> geometrycollection(Geometry<P> geometry, Geometry<P> ... geometries) {
        return new GeometryCollection(DSL.combine(Geometry.class, geometry, (Geometry[])geometries));
    }

    @SafeVarargs
    public static <P extends Position> GeometryCollection<P, Geometry<P>> geometrycollection(CoordinateReferenceSystem<P> crs, GeometryToken<P> ... tokens) {
        if (tokens.length == 0) {
            return new GeometryCollection(crs);
        }
        Geometry[] parts = new Geometry[tokens.length];
        int idx = 0;
        for (GeometryToken<P> t : tokens) {
            parts[idx++] = t.toGeometry(crs);
        }
        return new GeometryCollection(parts);
    }

    @SafeVarargs
    public static <P extends Position> GeometryCollectionToken<P> geometrycollection(GeometryToken<P> ... tokens) {
        return new GeometryCollectionToken<P>(tokens);
    }

    @SafeVarargs
    public static <P extends Position> Polygon<P> polygon(LinearRing<P> hull, LinearRing<P> ... rings) {
        LinearRing[] combined = (LinearRing[])DSL.combine(LinearRing.class, hull, (Geometry[])rings);
        return new Polygon(combined);
    }

    @SafeVarargs
    public static <P extends Position> Polygon<P> polygon(CoordinateReferenceSystem<P> crs, LinearRingToken<P> ... tokens) {
        if (tokens.length == 0) {
            return new Polygon<P>(crs);
        }
        LinearRing[] rings = new LinearRing[tokens.length];
        int idx = 0;
        for (LinearRingToken<P> t : tokens) {
            rings[idx++] = t.toGeometry((CoordinateReferenceSystem)crs);
        }
        return new Polygon(rings);
    }

    @SafeVarargs
    public static <P extends Position> PolygonToken<P> polygon(LinearRingToken<P> ... tokens) {
        return new PolygonToken<P>(tokens);
    }

    @SafeVarargs
    public static <P extends Position> MultiPoint<P> multipoint(Point<P> point, Point<P> ... points) {
        return new MultiPoint((Point[])DSL.combine(Point.class, point, (Geometry[])points));
    }

    @SafeVarargs
    public static <P extends Position> MultiPointToken<P> multipoint(PointToken<P> ... tokens) {
        return new MultiPointToken<P>(tokens);
    }

    public static <P extends Position> MultiPoint<P> multipoint(CoordinateReferenceSystem<P> crs) {
        return Geometries.mkEmptyMultiPoint(crs);
    }

    @SafeVarargs
    public static <P extends Position> MultiPoint<P> multipoint(CoordinateReferenceSystem<P> crs, P ... positions) {
        PositionSequence ps = Positions.collect(crs.getPositionClass(), positions);
        return Geometries.mkMultiPoint(ps, crs);
    }

    @SafeVarargs
    public static <P extends Position> MultiPoint<P> multipoint(CoordinateReferenceSystem<P> crs, PointToken<P> ... tokens) {
        if (tokens.length == 0) {
            return new MultiPoint<P>(crs);
        }
        Point[] points = new Point[tokens.length];
        int idx = 0;
        for (PointToken<P> t : tokens) {
            points[idx++] = t.toGeometry((CoordinateReferenceSystem)crs);
        }
        return new MultiPoint(points);
    }

    @SafeVarargs
    public static <P extends Position> MultiLineString<P> multilinestring(LineString<P> linestring, LineString<P> ... linestrings) {
        return new MultiLineString((LineString[])DSL.combine(LineString.class, linestring, (Geometry[])linestrings));
    }

    @SafeVarargs
    public static <P extends Position> MultiLineStringToken<P> multilinestring(LineStringToken<P> ... tokens) {
        return new MultiLineStringToken(tokens);
    }

    @SafeVarargs
    public static <P extends Position> MultiLineString<P> multilinestring(CoordinateReferenceSystem<P> crs, LineStringToken<P> ... tokens) {
        if (tokens.length == 0) {
            return new MultiLineString<P>(crs);
        }
        LineString[] linestrings = new LineString[tokens.length];
        int idx = 0;
        for (LineStringToken<P> t : tokens) {
            linestrings[idx++] = t.toGeometry((CoordinateReferenceSystem)crs);
        }
        return new MultiLineString(linestrings);
    }

    @SafeVarargs
    public static <P extends Position> MultiPolygon<P> multipolygon(Polygon<P> polygon, Polygon<P> ... polygons) {
        return new MultiPolygon((Polygon[])DSL.combine(Polygon.class, polygon, (Geometry[])polygons));
    }

    @SafeVarargs
    public static <P extends Position> MultiPolygonToken<P> multipolygon(PolygonToken<P> ... tokens) {
        return new MultiPolygonToken(tokens);
    }

    @SafeVarargs
    public static <P extends Position> MultiPolygon<P> multipolygon(CoordinateReferenceSystem<P> crs, PolygonToken<P> ... tokens) {
        if (tokens.length == 0) {
            return new MultiPolygon<P>(crs);
        }
        Polygon[] polygons = new Polygon[tokens.length];
        int idx = 0;
        for (PolygonToken<P> t : tokens) {
            polygons[idx++] = t.toGeometry((CoordinateReferenceSystem)crs);
        }
        return new MultiPolygon(polygons);
    }

    static <P extends Position> PositionSequence<P> toSeq(CoordinateReferenceSystem<P> crs, P[] positions) {
        PositionSequenceBuilder<P> builder = PositionSequenceBuilders.fixedSized(positions.length, crs.getPositionClass());
        double[] coords = new double[crs.getCoordinateDimension()];
        for (P t : positions) {
            P pos = Positions.mkPosition(crs, ((Position)t).toArray(coords));
            builder.add(pos);
        }
        return builder.toPositionSequence();
    }

    public static class MultiPolygonToken<P extends Position>
    extends GeometryToken<P> {
        private PolygonToken[] tokens;

        MultiPolygonToken(PolygonToken ... tokens) {
            this.tokens = Arrays.copyOf(tokens, tokens.length);
        }

        @Override
        MultiPolygon<P> toGeometry(CoordinateReferenceSystem<P> crs) {
            Polygon[] parts = new Polygon[this.tokens.length];
            for (int i = 0; i < this.tokens.length; ++i) {
                parts[i] = this.tokens[i].toGeometry((CoordinateReferenceSystem)crs);
            }
            return new MultiPolygon(parts);
        }
    }

    public static class MultiLineStringToken<P extends Position>
    extends GeometryToken<P> {
        private LineStringToken[] tokens;

        MultiLineStringToken(LineStringToken ... tokens) {
            this.tokens = Arrays.copyOf(tokens, tokens.length);
        }

        @Override
        MultiLineString<P> toGeometry(CoordinateReferenceSystem<P> crs) {
            LineString[] parts = new LineString[this.tokens.length];
            for (int i = 0; i < this.tokens.length; ++i) {
                parts[i] = this.tokens[i].toGeometry((CoordinateReferenceSystem)crs);
            }
            return new MultiLineString(parts);
        }
    }

    public static class MultiPointToken<P extends Position>
    extends GeometryToken<P> {
        private PointToken[] tokens;

        MultiPointToken(PointToken<P> ... tokens) {
            this.tokens = Arrays.copyOf(tokens, tokens.length);
        }

        @Override
        MultiPoint<P> toGeometry(CoordinateReferenceSystem<P> crs) {
            Point[] parts = new Point[this.tokens.length];
            for (int i = 0; i < this.tokens.length; ++i) {
                parts[i] = this.tokens[i].toGeometry((CoordinateReferenceSystem)crs);
            }
            return new MultiPoint(parts);
        }
    }

    public static class GeometryCollectionToken<P extends Position>
    extends GeometryToken<P> {
        private GeometryToken[] tokens;

        GeometryCollectionToken(GeometryToken<P> ... tokens) {
            this.tokens = Arrays.copyOf(tokens, tokens.length);
        }

        GeometryCollection<P, Geometry<P>> toGeometry(CoordinateReferenceSystem<P> crs) {
            Geometry[] parts = new Geometry[this.tokens.length];
            for (int i = 0; i < this.tokens.length; ++i) {
                parts[i] = this.tokens[i].toGeometry(crs);
            }
            return new GeometryCollection(parts);
        }
    }

    public static class PolygonToken<P extends Position>
    extends GeometryToken<P> {
        private LinearRingToken[] ringTokens;

        PolygonToken(LinearRingToken<P> ... ringTokens) {
            this.ringTokens = Arrays.copyOf(ringTokens, ringTokens.length);
        }

        @Override
        Polygon<P> toGeometry(CoordinateReferenceSystem<P> crs) {
            LinearRing[] rings = new LinearRing[this.ringTokens.length];
            for (int i = 0; i < rings.length; ++i) {
                rings[i] = this.ringTokens[i].toGeometry((CoordinateReferenceSystem)crs);
            }
            return new Polygon(rings);
        }
    }

    public static class LinearRingToken<P extends Position>
    extends GeometryToken<P> {
        private P[] positions;

        LinearRingToken(P ... positions) {
            this.positions = (Position[])Arrays.copyOf(positions, positions.length);
        }

        @Override
        LinearRing<P> toGeometry(CoordinateReferenceSystem<P> crs) {
            return new LinearRing<P>(DSL.toSeq(crs, this.positions), crs);
        }
    }

    public static class LineStringToken<P extends Position>
    extends GeometryToken<P> {
        private P[] positions;

        LineStringToken(P ... positions) {
            this.positions = (Position[])Arrays.copyOf(positions, positions.length);
        }

        @Override
        LineString<P> toGeometry(CoordinateReferenceSystem<P> crs) {
            return new LineString<P>(DSL.toSeq(crs, this.positions), crs);
        }
    }

    public static class PointToken<P extends Position>
    extends GeometryToken<P> {
        private P p;

        PointToken(P p) {
            this.p = p;
        }

        @Override
        Point<P> toGeometry(CoordinateReferenceSystem<P> crs) {
            return new Point<P>(this.p, crs);
        }
    }

    public static abstract class GeometryToken<P extends Position> {
        abstract Geometry<P> toGeometry(CoordinateReferenceSystem<P> var1);
    }
}

