/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphicsio.exportchooser.OptionButton;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class BackgroundPanel
extends OptionPanel {
    private Color initialBackground;
    private Color background;
    private JColorChooser colorChooser;
    private OptionButton colorButton;
    private String key;

    public BackgroundPanel(Properties options, String rootKey, boolean hasTransparency) {
        this(options, rootKey, hasTransparency, "Background");
    }

    public BackgroundPanel(Properties options, String rootKey, boolean hasTransparency, String title) {
        super(title);
        String right;
        this.key = rootKey + "." + "BackgroundColor";
        UserProperties user = new UserProperties(options);
        this.initialBackground = user.getPropertyColor(this.key);
        if (this.initialBackground == null) {
            this.initialBackground = Color.WHITE;
        }
        this.background = this.initialBackground;
        OptionCheckBox backgroundCheck = new OptionCheckBox(options, rootKey + "." + "Background", "Background");
        this.colorChooser = new JColorChooser(this.initialBackground);
        JDialog dialog = JColorChooser.createDialog(this, "Choose Background Color", true, this.colorChooser, new ChangeColorListener(), null);
        this.colorButton = new OptionButton(options, rootKey, "Select Color", dialog);
        backgroundCheck.enables(this.colorButton);
        String left = title == null ? "0 * [5 0 5 15] r" : "0 * [5 15 5 15] r";
        String string = right = title == null ? "1 * [5 15 5 0] lw" : "1 * [5 15 5 15] lw";
        if (hasTransparency) {
            OptionCheckBox transparentCheck = new OptionCheckBox(options, rootKey + "." + "Transparent", "Transparent");
            this.add(left, transparentCheck);
            this.add(right, new JLabel());
            transparentCheck.disables(backgroundCheck);
        }
        this.add(left, backgroundCheck);
        this.add(right, this.colorButton);
        new ChangeColorListener().actionPerformed(null);
    }

    public boolean applyChangedOptions(Properties options) {
        boolean changed = super.applyChangedOptions(options);
        if (!this.background.equals(this.initialBackground)) {
            UserProperties.setProperty((Properties)options, (String)this.key, (Color)this.background);
            changed = true;
        }
        return changed;
    }

    class ChangeColorListener
    implements ActionListener {
        ChangeColorListener() {
        }

        public void actionPerformed(ActionEvent event) {
            BackgroundPanel.this.background = BackgroundPanel.this.colorChooser.getColor();
            BackgroundPanel.this.colorButton.setBackground(BackgroundPanel.this.background);
            BackgroundPanel.this.colorButton.setForeground((Color)PrintColor.invert((Color)BackgroundPanel.this.background));
        }
    }
}

