/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.conf;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class FlowableTaskEventRegistryCondition
extends SpringBootCondition
implements AutoConfigurationImportFilter,
BeanFactoryAware,
Condition,
EnvironmentAware {
    protected BeanFactory beanFactory;
    protected Environment environment;

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionEvaluationReport report = ConditionEvaluationReport.find((BeanFactory)this.beanFactory);
        Map<String, ConditionOutcome> conditions = this.getConditionOutcomes();
        ConditionOutcome[] outcomes = this.getOutcomes(autoConfigurationClasses, conditions);
        boolean[] match = new boolean[outcomes.length];
        for (int i = 0; i < outcomes.length; ++i) {
            boolean bl = match[i] = outcomes[i] == null || outcomes[i].isMatch();
            if (match[i] || outcomes[i] == null) continue;
            this.logOutcome(autoConfigurationClasses[i], outcomes[i]);
            if (report == null) continue;
            report.recordConditionEvaluation(autoConfigurationClasses[i], (Condition)this, outcomes[i]);
        }
        return match;
    }

    protected Map<String, ConditionOutcome> getConditionOutcomes() {
        boolean jmsEnabled = (Boolean)this.environment.getProperty("flowable.task.app.jms-enabled", Boolean.class, (Object)false);
        boolean kafkaEnabled = (Boolean)this.environment.getProperty("flowable.task.app.kafka-enabled", Boolean.class, (Object)false);
        boolean rabbitEnabled = (Boolean)this.environment.getProperty("flowable.task.app.rabbit-enabled", Boolean.class, (Object)false);
        HashMap<String, ConditionOutcome> conditions = new HashMap<String, ConditionOutcome>();
        if (!jmsEnabled) {
            conditions.put("org.springframework.boot.autoconfigure.jms.activemq.ActiveMQAutoConfiguration", ConditionOutcome.noMatch((String)"Property flowable.task.app.jms-enabled was not set to true"));
        }
        if (!kafkaEnabled) {
            conditions.put("org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration", ConditionOutcome.noMatch((String)"Property flowable.task.app.kafka-enabled was not set to true"));
        }
        if (!rabbitEnabled) {
            conditions.put("org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration", ConditionOutcome.noMatch((String)"Property flowable.task.app.rabbit-enabled was not set to true"));
        }
        return conditions;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.empty());
    }

    protected ConditionOutcome[] getOutcomes(String[] autoConfigurationClasses, Map<String, ConditionOutcome> conditionOutcomes) {
        ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        for (int i = 0; i < autoConfigurationClasses.length; ++i) {
            outcomes[i] = conditionOutcomes.get(autoConfigurationClasses[i]);
        }
        return outcomes;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

