/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.FindExpiredJobsCmd;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsCmd;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetExpiredJobsRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetExpiredJobsRunnable.class);
    protected final String name;
    protected final AsyncExecutor asyncExecutor;
    protected final JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public ResetExpiredJobsRunnable(String name, AsyncExecutor asyncExecutor, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.name = name;
        this.asyncExecutor = asyncExecutor;
        this.jobEntityManager = jobEntityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        LOGGER.info("starting to reset expired jobs for engine {}", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName());
        Thread.currentThread().setName(this.name);
        while (!this.isInterrupted) {
            this.resetJobs();
            try {
                Object object = this.MONITOR;
                synchronized (object) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.asyncExecutor.getResetExpiredJobsInterval());
                    }
                }
            }
            catch (InterruptedException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("async reset expired jobs wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        LOGGER.info("stopped resetting expired jobs for engine {}", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName());
    }

    public void resetJobs() {
        boolean hasExpiredJobs = true;
        while (hasExpiredJobs) {
            try {
                List expiredJobs = (List)this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor().execute((Command)new FindExpiredJobsCmd(this.asyncExecutor.getResetExpiredJobsPageSize(), this.jobEntityManager));
                List<String> expiredJobIds = expiredJobs.stream().map(Entity::getId).collect(Collectors.toList());
                if (!expiredJobIds.isEmpty()) {
                    this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor().execute((Command)new ResetExpiredJobsCmd(expiredJobIds, this.jobEntityManager));
                    continue;
                }
                hasExpiredJobs = false;
            }
            catch (Throwable e) {
                if (e instanceof FlowableOptimisticLockingException) {
                    LOGGER.debug("Optimistic lock exception while resetting locked jobs for engine {}", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName(), (Object)e);
                    continue;
                }
                LOGGER.error("exception during resetting expired jobs: {} for engine {}", new Object[]{e.getMessage(), this.asyncExecutor.getJobServiceConfiguration().getEngineName(), e});
                hasExpiredJobs = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }
}

