/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.identitylink.service.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityImpl;
import org.flowable.identitylink.service.impl.persistence.entity.data.IdentityLinkDataManager;
import org.flowable.identitylink.service.impl.persistence.entity.data.impl.cachematcher.IdentityLinksByProcessInstanceMatcher;
import org.flowable.identitylink.service.impl.persistence.entity.data.impl.cachematcher.IdentityLinksByScopeIdAndTypeMatcher;
import org.flowable.identitylink.service.impl.persistence.entity.data.impl.cachematcher.IdentityLinksByTaskIdMatcher;

public class MybatisIdentityLinkDataManager
extends AbstractDataManager<IdentityLinkEntity>
implements IdentityLinkDataManager {
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinksByTaskIdMatcher = new IdentityLinksByTaskIdMatcher();
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinkByProcessInstanceMatcher = new IdentityLinksByProcessInstanceMatcher();
    protected CachedEntityMatcher<IdentityLinkEntity> identityLinksByScopeIdAndTypeMatcher = new IdentityLinksByScopeIdAndTypeMatcher();

    public Class<? extends IdentityLinkEntity> getManagedEntityClass() {
        return IdentityLinkEntityImpl.class;
    }

    public IdentityLinkEntity create() {
        return new IdentityLinkEntityImpl();
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "task", taskId)) {
            return this.getListFromCache(this.identityLinksByTaskIdMatcher, taskId);
        }
        return this.getList("selectIdentityLinksByTaskId", taskId, this.identityLinkByProcessInstanceMatcher, true);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(String processInstanceId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", processInstanceId)) {
            return this.getListFromCache(this.identityLinkByProcessInstanceMatcher, processInstanceId);
        }
        return this.getList("selectIdentityLinksByProcessInstance", processInstanceId, this.identityLinkByProcessInstanceMatcher, true);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByScopeIdAndType(String scopeId, String scopeType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scopeId", scopeId);
        parameters.put("scopeType", scopeType);
        return this.getList("selectIdentityLinksByScopeIdAndType", parameters, this.identityLinksByScopeIdAndTypeMatcher, true);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByScopeDefinitionIdAndType(String scopeDefinitionId, String scopeType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scopeDefinitionId", scopeDefinitionId);
        parameters.put("scopeType", scopeType);
        return this.getDbSqlSession().selectList("selectIdentityLinksByScopeDefinitionAndType", parameters);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByProcessDefinition", (Object)processDefinitionId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByTaskUserGroupAndType", parameters);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserGroupAndType(String processInstanceId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByProcessInstanceUserGroupAndType", parameters);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        return this.getDbSqlSession().selectList("selectIdentityLinkByProcessDefinitionUserAndGroup", parameters);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByScopeIdScopeTypeUserGroupAndType(String scopeId, String scopeType, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scopeId", scopeId);
        parameters.put("scopeType", scopeType);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByScopeIdScopeTypeUserGroupAndType", parameters);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByScopeDefinitionScopeTypeUserAndGroup(String scopeDefinitionId, String scopeType, String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scopeDefinitionId", scopeDefinitionId);
        parameters.put("scopeType", scopeType);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        return this.getDbSqlSession().selectList("selectIdentityLinkByScopeDefinitionScopeTypeUserAndGroup", parameters);
    }

    @Override
    public void deleteIdentityLinksByTaskId(String taskId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "task", taskId)) {
            this.deleteCachedEntities(dbSqlSession, this.identityLinksByTaskIdMatcher, taskId);
        } else {
            this.bulkDelete("deleteIdentityLinksByTaskId", this.identityLinksByTaskIdMatcher, taskId);
        }
    }

    @Override
    public void deleteIdentityLinksByProcDef(String processDefId) {
        this.getDbSqlSession().delete("deleteIdentityLinksByProcDef", (Object)processDefId, IdentityLinkEntityImpl.class);
    }

    @Override
    public void deleteIdentityLinksByProcessInstanceId(String processInstanceId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", processInstanceId)) {
            this.deleteCachedEntities(dbSqlSession, this.identityLinkByProcessInstanceMatcher, processInstanceId);
        } else {
            this.bulkDelete("deleteIdentityLinksByProcessInstanceId", this.identityLinkByProcessInstanceMatcher, processInstanceId);
        }
    }

    @Override
    public void deleteIdentityLinksByScopeIdAndScopeType(String scopeId, String scopeType) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scopeId", scopeId);
        if ("cmmn".equals(scopeType) && this.isEntityInserted(dbSqlSession, "caseInstance", scopeId)) {
            this.deleteCachedEntities(dbSqlSession, this.identityLinksByScopeIdAndTypeMatcher, parameters);
        } else {
            parameters.put("scopeType", scopeType);
            this.bulkDelete("deleteIdentityLinksByScopeIdAndScopeType", this.identityLinksByScopeIdAndTypeMatcher, parameters);
        }
    }

    @Override
    public void deleteIdentityLinksByScopeDefinitionIdAndScopeType(String scopeDefinitionId, String scopeType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("scopeDefinitionId", scopeDefinitionId);
        parameters.put("scopeType", scopeType);
        this.getDbSqlSession().delete("deleteIdentityLinksByScopeDefinitionIdAndScopeType", parameters, IdentityLinkEntityImpl.class);
    }
}

