/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el.function;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.FlowableFunctionDelegate;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstFunction;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstIdentifier;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstNode;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstParameters;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstText;
import org.flowable.common.engine.impl.el.FlowableAstFunctionCreator;
import org.flowable.common.engine.impl.el.FlowableExpressionParser;

public abstract class AbstractFlowableVariableExpressionFunction
implements FlowableAstFunctionCreator,
FlowableFunctionDelegate {
    private static final List<String> FUNCTION_PREFIXES = Arrays.asList("variables", "vars", "var");
    protected Method method;
    protected String functionName;
    protected Collection<String> functionNamesOptions;
    protected String variableScopeName = "variableContainer";

    public AbstractFlowableVariableExpressionFunction(String functionName) {
        this(Collections.singletonList(functionName), functionName);
    }

    public AbstractFlowableVariableExpressionFunction(List<String> functionNameOptions, String functionName) {
        this.functionNamesOptions = new LinkedHashSet<String>(functionNameOptions);
        this.functionName = functionName;
    }

    protected Method findMethod(String functionName) {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(functionName)) continue;
            return method;
        }
        throw new FlowableException("Programmatic error: could not find method " + functionName + " on class " + this.getClass());
    }

    public String prefix() {
        throw new UnsupportedOperationException("Function has more than one prefix");
    }

    public Collection<String> prefixes() {
        return FUNCTION_PREFIXES;
    }

    public String localName() {
        throw new UnsupportedOperationException("Function has more than one local name");
    }

    public Collection<String> localNames() {
        return this.functionNamesOptions;
    }

    public Method functionMethod() {
        if (this.method != null) {
            return this.method;
        }
        this.method = this.findMethod(this.functionName);
        return this.method;
    }

    protected static Object getVariableValue(VariableContainer variableContainer, String variableName) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("Variable name passed is null");
        }
        return variableContainer.getVariable(variableName);
    }

    protected static boolean valuesAreNumbers(Object variableValue, Object actualValue) {
        return actualValue instanceof Number && variableValue instanceof Number;
    }

    @Override
    public Collection<String> getFunctionNames() {
        LinkedHashSet<String> functionNames = new LinkedHashSet<String>();
        for (String functionPrefix : this.prefixes()) {
            for (String functionNameOption : this.localNames()) {
                functionNames.add(functionPrefix + ":" + functionNameOption);
            }
        }
        return functionNames;
    }

    @Override
    public AstFunction createFunction(String name, int index, AstParameters parameters, boolean varargs, FlowableExpressionParser parser) {
        Method method = this.functionMethod();
        int parametersCardinality = parameters.getCardinality();
        int methodParameterCount = method.getParameterCount();
        if (method.isVarArgs() || parametersCardinality < methodParameterCount) {
            ArrayList<AstNode> newParameters = new ArrayList<AstNode>(parametersCardinality + 1);
            newParameters.add(parser.createIdentifier(this.variableScopeName));
            if (methodParameterCount >= 1) {
                newParameters.add(this.createVariableNameNode(parameters.getChild(0)));
                for (int i = 1; i < parametersCardinality; ++i) {
                    newParameters.add(parameters.getChild(i));
                }
            }
            return new AstFunction(name, index, new AstParameters(newParameters), varargs);
        }
        return new AstFunction(name, index, parameters, varargs);
    }

    protected AstNode createVariableNameNode(AstNode variableNode) {
        if (variableNode instanceof AstIdentifier) {
            return new AstText(((AstIdentifier)variableNode).getName());
        }
        return variableNode;
    }
}

