/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnDeploymentQuery;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseDecisionTableResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    protected DmnDecisionTable getDecisionTableFromRequest(String decisionTableId) {
        DmnDecisionTable decisionTable = this.dmnRepositoryService.getDecisionTable(decisionTableId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("Could not find a decision table with id '" + decisionTableId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDecisionTableInfoById(decisionTable);
        }
        return decisionTable;
    }

    protected byte[] getDeploymentResourceData(String deploymentId, String resourceId, HttpServletResponse response) {
        List resourceList;
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("No deployment id provided");
        }
        if (resourceId == null) {
            throw new FlowableIllegalArgumentException("No resource id provided");
        }
        DmnDeploymentQuery deploymentQuery = this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId);
        DmnDeployment deployment = (DmnDeployment)deploymentQuery.singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        if ((resourceList = this.dmnRepositoryService.getDeploymentResourceNames(deploymentId)).contains(resourceId)) {
            InputStream resourceStream = this.dmnRepositoryService.getResourceAsStream(deploymentId, resourceId);
            String contentType = this.contentTypeResolver.resolveContentType(resourceId);
            response.setContentType(contentType);
            try {
                return IOUtils.toByteArray((InputStream)resourceStream);
            }
            catch (Exception e) {
                throw new FlowableException("Error converting resource stream", (Throwable)e);
            }
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with id '" + resourceId + "' in deployment '" + deploymentId);
    }
}

