/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.spring;

import java.net.URL;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.content.engine.ContentEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringContentConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringContentConfigurationHelper.class);

    public static ContentEngine buildContentEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND CONTENT ENGINE =========================================");
        GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});
        Map beansOfType = applicationContext.getBeansOfType(ContentEngine.class);
        if (beansOfType == null || beansOfType.isEmpty()) {
            throw new FlowableException("no " + ContentEngine.class.getName() + " defined in the application context " + resource.toString());
        }
        ContentEngine contentEngine = (ContentEngine)beansOfType.values().iterator().next();
        LOGGER.debug("==== SPRING CONTENT ENGINE CREATED ==================================================================");
        return contentEngine;
    }
}

