/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.db;

import java.sql.Connection;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.DbSchemaManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentDbSchemaManager
implements DbSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDbSchemaManager.class);
    public static String LIQUIBASE_CHANGELOG = "org/flowable/content/db/liquibase/flowable-content-db-changelog.xml";

    public void dbSchemaCreate() {
        Liquibase liquibase = ContentDbSchemaManager.createLiquibaseInstance(CommandContextUtil.getContentEngineConfiguration());
        try {
            liquibase.update("content");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating content engine tables", (Throwable)e);
        }
    }

    public void dbSchemaDrop() {
        Liquibase liquibase = ContentDbSchemaManager.createLiquibaseInstance(CommandContextUtil.getContentEngineConfiguration());
        try {
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping content engine tables", (Throwable)e);
        }
    }

    public String dbSchemaUpdate() {
        this.dbSchemaCreate();
        return null;
    }

    protected static Liquibase createLiquibaseInstance(ContentEngineConfiguration configuration) {
        try {
            Connection jdbcConnection = null;
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            jdbcConnection = commandContext == null ? configuration.getDataSource().getConnection() : CommandContextUtil.getDbSqlSession(commandContext).getSqlSession().getConnection();
            if (!jdbcConnection.getAutoCommit()) {
                jdbcConnection.commit();
            }
            JdbcConnection connection = new JdbcConnection(jdbcConnection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_CO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_CO_" + database.getDatabaseChangeLogLockTableName());
            Liquibase liquibase = new Liquibase(LIQUIBASE_CHANGELOG, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            return liquibase;
        }
        catch (Exception e) {
            throw new FlowableException("Error creating liquibase instance", (Throwable)e);
        }
    }

    public void initSchema(ContentEngineConfiguration configuration, String databaseSchemaUpdate) {
        try {
            Liquibase liquibase = ContentDbSchemaManager.createLiquibaseInstance(configuration);
            if ("drop-create".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Dropping and creating schema Content");
                liquibase.dropAll();
                liquibase.update("content");
            } else if ("true".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Updating schema Content");
                liquibase.update("content");
            } else if ("false".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Validating schema Content");
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising Content schema", (Throwable)e);
        }
    }
}

