/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.scripting;

import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.ScriptTraceEnhancer;
import org.flowable.task.api.Task;

public class CmmnEngineScriptTraceEnhancer
implements ScriptTraceEnhancer {
    private static final String EMPTY_INDICATOR = "<empty>";

    public void enhanceScriptTrace(ScriptTraceEnhancer.ScriptTraceContext scriptTrace) {
        this.enhanceScriptTrace(scriptTrace, scriptTrace.getVariableContainer());
    }

    protected void enhanceScriptTrace(ScriptTraceEnhancer.ScriptTraceContext scriptTrace, VariableContainer container) {
        if (container instanceof Task) {
            Task task = (Task)container;
            if ("cmmn".equals(task.getScopeType())) {
                scriptTrace.addTraceTag("scopeType", "cmmn");
                CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(task.getScopeDefinitionId());
                scriptTrace.addTraceTag("scopeDefinitionKey", caseDefinition.getKey());
                scriptTrace.addTraceTag("scopeDefinitionId", caseDefinition.getId());
                scriptTrace.addTraceTag("subScopeDefinitionKey", task.getTaskDefinitionKey());
            }
        } else if (container instanceof DelegatePlanItemInstance) {
            scriptTrace.addTraceTag("scopeType", "cmmn");
            DelegatePlanItemInstance planItemInstance = (DelegatePlanItemInstance)container;
            CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(planItemInstance.getCaseDefinitionId());
            scriptTrace.addTraceTag("scopeDefinitionKey", caseDefinition.getKey());
            scriptTrace.addTraceTag("scopeDefinitionId", planItemInstance.getCaseDefinitionId());
            scriptTrace.addTraceTag("subScopeDefinitionKey", planItemInstance.getPlanItemDefinitionId());
            this.addTenantId(scriptTrace, planItemInstance.getTenantId());
        } else if (container instanceof CaseInstance) {
            scriptTrace.addTraceTag("scopeType", "cmmn");
            CaseInstance caseInstance = (CaseInstance)container;
            CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(caseInstance.getCaseDefinitionId());
            scriptTrace.addTraceTag("scopeDefinitionKey", caseDefinition.getKey());
            scriptTrace.addTraceTag("scopeDefinitionId", caseDefinition.getId());
            this.addTenantId(scriptTrace, caseInstance.getTenantId());
        }
    }

    protected void addTenantId(ScriptTraceEnhancer.ScriptTraceContext scriptTrace, String tenantId) {
        if (tenantId != null && !tenantId.isEmpty()) {
            scriptTrace.addTraceTag("tenantId", tenantId);
        } else {
            scriptTrace.addTraceTag("tenantId", EMPTY_INDICATOR);
        }
    }
}

