
CREATE TABLE [DATABASECHANGELOG] ([ID] [nvarchar](255) NOT NULL, [AUTHOR] [nvarchar](255) NOT NULL, [FILENAME] [nvarchar](255) NOT NULL, [DATEEXECUTED] [datetime2](3) NOT NULL, [ORDEREXECUTED] [int] NOT NULL, [EXECTYPE] [nvarchar](10) NOT NULL, [MD5SUM] [nvarchar](35), [DESCRIPTION] [nvarchar](255), [COMMENTS] [nvarchar](255), [TAG] [nvarchar](255), [LIQUIBASE] [nvarchar](20), [CONTEXTS] [nvarchar](255), [LABELS] [nvarchar](255), [DEPLOYMENT_ID] [nvarchar](10))
GO

CREATE TABLE [ACT_CMMN_RE_DEPLOYMENT] ([ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255), [CATEGORY_] [varchar](255), [DEPLOY_TIME_] [datetime], [PARENT_DEPLOYMENT_ID_] [varchar](255), [TENANT_ID_] [varchar](255), CONSTRAINT [PK_ACT_CMMN_RE_DEPLOYMENT] PRIMARY KEY ([ID_]))
GO

CREATE TABLE [ACT_CMMN_RE_DEPLOYMENT_RESOURCE] ([ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255), [DEPLOYMENT_ID_] [varchar](255), [RESOURCE_BYTES_] [varbinary](MAX), CONSTRAINT [PK_ACT_CMMN_RE_DEPLOYMENT_RESOURCE] PRIMARY KEY ([ID_]))
GO

ALTER TABLE [ACT_CMMN_RE_DEPLOYMENT_RESOURCE] ADD CONSTRAINT [ACT_FK_CMMN_RSRC_DPL] FOREIGN KEY ([DEPLOYMENT_ID_]) REFERENCES [ACT_CMMN_RE_DEPLOYMENT] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_CMMN_RSRC_DPL ON [ACT_CMMN_RE_DEPLOYMENT_RESOURCE]([DEPLOYMENT_ID_])
GO

CREATE TABLE [ACT_CMMN_RE_CASEDEF] ([ID_] [varchar](255) NOT NULL, [REV_] [int] NOT NULL, [NAME_] [varchar](255), [KEY_] [varchar](255) NOT NULL, [VERSION_] [varchar](255) NOT NULL, [CATEGORY_] [varchar](255), [DEPLOYMENT_ID_] [varchar](255), [RESOURCE_NAME_] [varchar](4000), [DESCRIPTION_] [varchar](4000), [HAS_GRAPHICAL_NOTATION_] [bit], [TENANT_ID_] [varchar](255) CONSTRAINT [DF_ACT_CMMN_RE_CASEDEF_TENANT_ID_] DEFAULT '' NOT NULL, CONSTRAINT [PK_ACT_CMMN_RE_CASEDEF] PRIMARY KEY ([ID_]))
GO

ALTER TABLE [ACT_CMMN_RE_CASEDEF] ADD CONSTRAINT [ACT_FK_CASE_DEF_DPLY] FOREIGN KEY ([DEPLOYMENT_ID_]) REFERENCES [ACT_CMMN_RE_DEPLOYMENT] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_CASE_DEF_DPLY ON [ACT_CMMN_RE_CASEDEF]([DEPLOYMENT_ID_])
GO

CREATE TABLE [ACT_CMMN_RU_CASE_INST] ([ID_] [varchar](255) NOT NULL, [REV_] [int] NOT NULL, [BUSINESS_KEY_] [varchar](255), [NAME_] [varchar](255), [PARENT_ID_] [varchar](255), [CASE_DEF_ID_] [varchar](255), [STATE_] [varchar](255), [START_TIME_] [datetime], [START_USER_ID_] [varchar](255), [CALLBACK_ID_] [varchar](255), [CALLBACK_TYPE_] [varchar](255), [TENANT_ID_] [varchar](255) CONSTRAINT [DF_ACT_CMMN_RU_CASE_INST_TENANT_ID_] DEFAULT '', CONSTRAINT [PK_ACT_CMMN_RU_CASE_INST] PRIMARY KEY ([ID_]))
GO

ALTER TABLE [ACT_CMMN_RU_CASE_INST] ADD CONSTRAINT [ACT_FK_CASE_INST_CASE_DEF] FOREIGN KEY ([CASE_DEF_ID_]) REFERENCES [ACT_CMMN_RE_CASEDEF] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_CASE_INST_CASE_DEF ON [ACT_CMMN_RU_CASE_INST]([CASE_DEF_ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_CASE_INST_PARENT ON [ACT_CMMN_RU_CASE_INST]([PARENT_ID_])
GO

CREATE TABLE [ACT_CMMN_RU_PLAN_ITEM_INST] ([ID_] [varchar](255) NOT NULL, [REV_] [int] NOT NULL, [CASE_DEF_ID_] [varchar](255), [CASE_INST_ID_] [varchar](255), [STAGE_INST_ID_] [varchar](255), [IS_STAGE_] [bit], [ELEMENT_ID_] [varchar](255), [NAME_] [varchar](255), [STATE_] [varchar](255), [START_TIME_] [datetime], [START_USER_ID_] [varchar](255), [REFERENCE_ID_] [varchar](255), [REFERENCE_TYPE_] [varchar](255), [TENANT_ID_] [varchar](255) CONSTRAINT [DF_ACT_CMMN_RU_PLAN_ITEM_INST_TENANT_ID_] DEFAULT '', CONSTRAINT [PK_ACT_CMMN_RU_PLAN_ITEM_INST] PRIMARY KEY ([ID_]))
GO

ALTER TABLE [ACT_CMMN_RU_PLAN_ITEM_INST] ADD CONSTRAINT [ACT_FK_PLAN_ITEM_CASE_DEF] FOREIGN KEY ([CASE_DEF_ID_]) REFERENCES [ACT_CMMN_RE_CASEDEF] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_PLAN_ITEM_CASE_DEF ON [ACT_CMMN_RU_PLAN_ITEM_INST]([CASE_DEF_ID_])
GO

ALTER TABLE [ACT_CMMN_RU_PLAN_ITEM_INST] ADD CONSTRAINT [ACT_FK_PLAN_ITEM_CASE_INST] FOREIGN KEY ([CASE_INST_ID_]) REFERENCES [ACT_CMMN_RU_CASE_INST] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_PLAN_ITEM_CASE_INST ON [ACT_CMMN_RU_PLAN_ITEM_INST]([CASE_INST_ID_])
GO

CREATE TABLE [ACT_CMMN_RU_SENTRY_ON_PART_INST] ([ID_] [varchar](255) NOT NULL, [REV_] [int] NOT NULL, [CASE_DEF_ID_] [varchar](255), [CASE_INST_ID_] [varchar](255), [PLAN_ITEM_INST_ID_] [varchar](255), [ON_PART_ID_] [varchar](255), [TIME_STAMP_] [datetime], CONSTRAINT [PK_ACT_CMMN_RU_SENTRY_ON_PART_INST] PRIMARY KEY ([ID_]))
GO

ALTER TABLE [ACT_CMMN_RU_SENTRY_ON_PART_INST] ADD CONSTRAINT [ACT_FK_SENTRY_CASE_DEF] FOREIGN KEY ([CASE_DEF_ID_]) REFERENCES [ACT_CMMN_RE_CASEDEF] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_SENTRY_CASE_DEF ON [ACT_CMMN_RU_SENTRY_ON_PART_INST]([CASE_DEF_ID_])
GO

ALTER TABLE [ACT_CMMN_RU_SENTRY_ON_PART_INST] ADD CONSTRAINT [ACT_FK_SENTRY_CASE_INST] FOREIGN KEY ([CASE_INST_ID_]) REFERENCES [ACT_CMMN_RU_CASE_INST] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_SENTRY_CASE_INST ON [ACT_CMMN_RU_SENTRY_ON_PART_INST]([CASE_INST_ID_])
GO

ALTER TABLE [ACT_CMMN_RU_SENTRY_ON_PART_INST] ADD CONSTRAINT [ACT_FK_SENTRY_PLAN_ITEM] FOREIGN KEY ([PLAN_ITEM_INST_ID_]) REFERENCES [ACT_CMMN_RU_PLAN_ITEM_INST] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_SENTRY_PLAN_ITEM ON [ACT_CMMN_RU_SENTRY_ON_PART_INST]([PLAN_ITEM_INST_ID_])
GO

CREATE TABLE [ACT_CMMN_RU_MIL_INST] ([ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255) NOT NULL, [TIME_STAMP_] [datetime] NOT NULL, [CASE_INST_ID_] [varchar](255) NOT NULL, [CASE_DEF_ID_] [varchar](255) NOT NULL, [ELEMENT_ID_] [varchar](255) NOT NULL, CONSTRAINT [PK_ACT_CMMN_RU_MIL_INST] PRIMARY KEY ([ID_]))
GO

ALTER TABLE [ACT_CMMN_RU_MIL_INST] ADD CONSTRAINT [ACT_FK_MIL_CASE_DEF] FOREIGN KEY ([CASE_DEF_ID_]) REFERENCES [ACT_CMMN_RE_CASEDEF] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_MIL_CASE_DEF ON [ACT_CMMN_RU_MIL_INST]([CASE_DEF_ID_])
GO

ALTER TABLE [ACT_CMMN_RU_MIL_INST] ADD CONSTRAINT [ACT_FK_MIL_CASE_INST] FOREIGN KEY ([CASE_INST_ID_]) REFERENCES [ACT_CMMN_RU_CASE_INST] ([ID_])
GO

CREATE NONCLUSTERED INDEX ACT_IDX_MIL_CASE_INST ON [ACT_CMMN_RU_MIL_INST]([CASE_INST_ID_])
GO

CREATE TABLE [ACT_CMMN_HI_CASE_INST] ([ID_] [varchar](255) NOT NULL, [REV_] [int] NOT NULL, [BUSINESS_KEY_] [varchar](255), [NAME_] [varchar](255), [PARENT_ID_] [varchar](255), [CASE_DEF_ID_] [varchar](255), [STATE_] [varchar](255), [START_TIME_] [datetime], [END_TIME_] [datetime], [START_USER_ID_] [varchar](255), [CALLBACK_ID_] [varchar](255), [CALLBACK_TYPE_] [varchar](255), [TENANT_ID_] [varchar](255) CONSTRAINT [DF_ACT_CMMN_HI_CASE_INST_TENANT_ID_] DEFAULT '', CONSTRAINT [PK_ACT_CMMN_HI_CASE_INST] PRIMARY KEY ([ID_]))
GO

CREATE TABLE [ACT_CMMN_HI_MIL_INST] ([ID_] [varchar](255) NOT NULL, [REV_] [int] NOT NULL, [NAME_] [varchar](255) NOT NULL, [TIME_STAMP_] [datetime] NOT NULL, [CASE_INST_ID_] [varchar](255) NOT NULL, [CASE_DEF_ID_] [varchar](255) NOT NULL, [ELEMENT_ID_] [varchar](255) NOT NULL, CONSTRAINT [PK_ACT_CMMN_HI_MIL_INST] PRIMARY KEY ([ID_]))
GO

INSERT INTO [DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('1', 'flowable', 'org/flowable/cmmn/db/liquibase/flowable-cmmn-db-changelog.xml', GETDATE(), 1, '7:28e5931d36abab0185c189c584a7c2d0', 'createTable tableName=ACT_CMMN_RE_DEPLOYMENT; createTable tableName=ACT_CMMN_RE_DEPLOYMENT_RESOURCE; addForeignKeyConstraint baseTableName=ACT_CMMN_RE_DEPLOYMENT_RESOURCE, constraintName=ACT_FK_CMMN_RSRC_DPL, referencedTableName=ACT_CMMN_RE_DEPLOY...', '', 'EXECUTED', NULL, NULL, '3.5.3', '4471205429')
GO

