/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceChangeState;
import org.flowable.cmmn.engine.impl.runtime.ChangePlanItemStateBuilderImpl;
import org.flowable.cmmn.engine.impl.runtime.MovePlanItemDefinitionIdContainer;
import org.flowable.cmmn.engine.impl.runtime.MovePlanItemInstanceEntityContainer;
import org.flowable.cmmn.engine.impl.runtime.MovePlanItemInstanceIdContainer;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmmnDynamicStateManager {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public List<MovePlanItemInstanceEntityContainer> resolveMovePlanItemInstanceEntityContainers(ChangePlanItemStateBuilderImpl changePlanItemStateBuilder, String migrateToCaseDefinitionId, Map<String, Object> variables, CommandContext commandContext) {
        ArrayList<MovePlanItemInstanceEntityContainer> movePlanItemInstanceEntityContainerList = new ArrayList<MovePlanItemInstanceEntityContainer>();
        if (changePlanItemStateBuilder.getMovePlanItemInstanceIdList().size() > 0) {
            for (MovePlanItemInstanceIdContainer planItemInstanceContainer : changePlanItemStateBuilder.getMovePlanItemInstanceIdList()) {
                HashMap<String, List> planItemInstancesByParent = new HashMap<String, List>();
                for (String planItemInstanceId : planItemInstanceContainer.getPlanItemInstanceIds()) {
                    PlanItemInstanceEntity planItemInstance = this.resolvePlanItemInstance(planItemInstanceId, commandContext);
                    List currentPlanItemInstanceEntities = planItemInstancesByParent.computeIfAbsent(planItemInstance.getStageInstanceId(), k -> new ArrayList());
                    currentPlanItemInstanceEntities.add(planItemInstance);
                }
                planItemInstancesByParent.values().forEach(planItemInstances -> {
                    MovePlanItemInstanceEntityContainer movePlanItemInstanceEntityContainer = new MovePlanItemInstanceEntityContainer((List<PlanItemInstanceEntity>)planItemInstances, planItemInstanceContainer.getMoveToPlanItemDefinitionIds());
                    PlanItemInstanceEntity firstPlanItemInstance = (PlanItemInstanceEntity)planItemInstances.get(0);
                    movePlanItemInstanceEntityContainer.setCaseDefinitionId(firstPlanItemInstance.getCaseDefinitionId());
                    movePlanItemInstanceEntityContainer.setCaseInstanceId(firstPlanItemInstance.getCaseInstanceId());
                    movePlanItemInstanceEntityContainer.setTenantId(firstPlanItemInstance.getTenantId());
                    if (planItemInstanceContainer.getNewAssigneeId() != null) {
                        movePlanItemInstanceEntityContainer.setNewAssigneeId(planItemInstanceContainer.getNewAssigneeId());
                    }
                    movePlanItemInstanceEntityContainerList.add(movePlanItemInstanceEntityContainer);
                });
            }
        }
        if (changePlanItemStateBuilder.getMovePlanItemDefinitionIdList().size() > 0) {
            for (MovePlanItemDefinitionIdContainer planItemDefinitionContainer : changePlanItemStateBuilder.getMovePlanItemDefinitionIdList()) {
                for (String planItemDefinitionId : planItemDefinitionContainer.getPlanItemDefinitionIds()) {
                    List<PlanItemInstanceEntity> currentPlanItemInstances = this.resolvePlanItemInstances(changePlanItemStateBuilder.getCaseInstanceId(), planItemDefinitionId, commandContext);
                    if (currentPlanItemInstances.isEmpty()) continue;
                    movePlanItemInstanceEntityContainerList.add(this.createMovePlanItemInstanceEntityContainer(planItemDefinitionContainer, currentPlanItemInstances, commandContext));
                }
            }
        }
        return movePlanItemInstanceEntityContainerList;
    }

    protected PlanItemInstanceEntity resolvePlanItemInstance(String planItemInstanceId, CommandContext commandContext) {
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext);
        PlanItemInstanceEntity planItemInstance = (PlanItemInstanceEntity)planItemInstanceEntityManager.findById(planItemInstanceId);
        if (planItemInstance == null) {
            throw new FlowableException("PlanItemInstance could not be found with id " + planItemInstanceId);
        }
        return planItemInstance;
    }

    protected List<PlanItemInstanceEntity> resolvePlanItemInstances(String caseInstanceId, String planItemDefinitionId, CommandContext commandContext) {
        CaseInstanceEntityManager caseInstanceEntityManager = CommandContextUtil.getCaseInstanceEntityManager(commandContext);
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)caseInstanceEntityManager.findById(caseInstanceId);
        if (caseInstance == null) {
            throw new FlowableException("Case instance could not be found with id " + caseInstanceId);
        }
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext);
        List<PlanItemInstanceEntity> planItemInstances = planItemInstanceEntityManager.findByCaseInstanceId(caseInstanceId);
        List<PlanItemInstanceEntity> resultPlanItemInstances = planItemInstances.stream().filter(e -> e.getPlanItemDefinitionId() != null).filter(e -> e.getPlanItemDefinitionId().equals(planItemDefinitionId)).filter(e -> e.getEndedTime() == null).collect(Collectors.toList());
        if (resultPlanItemInstances.isEmpty()) {
            throw new FlowableException("Plan item instance could not be found with plan item definition id " + planItemDefinitionId);
        }
        return resultPlanItemInstances;
    }

    protected MovePlanItemInstanceEntityContainer createMovePlanItemInstanceEntityContainer(MovePlanItemDefinitionIdContainer planItemDefinitionContainer, List<PlanItemInstanceEntity> planItemInstances, CommandContext commandContext) {
        MovePlanItemInstanceEntityContainer movePlanItemInstanceEntityContainer = new MovePlanItemInstanceEntityContainer(planItemInstances, planItemDefinitionContainer.getMoveToPlanItemDefinitionIds());
        PlanItemInstanceEntity firstPlanItemInstance = planItemInstances.get(0);
        movePlanItemInstanceEntityContainer.setCaseDefinitionId(firstPlanItemInstance.getCaseDefinitionId());
        movePlanItemInstanceEntityContainer.setCaseInstanceId(firstPlanItemInstance.getCaseInstanceId());
        movePlanItemInstanceEntityContainer.setTenantId(firstPlanItemInstance.getTenantId());
        if (planItemDefinitionContainer.getNewAssigneeId() != null) {
            movePlanItemInstanceEntityContainer.setNewAssigneeId(planItemDefinitionContainer.getNewAssigneeId());
        }
        return movePlanItemInstanceEntityContainer;
    }

    protected void prepareMovePlanItemInstanceEntityContainer(MovePlanItemInstanceEntityContainer movePlanItemInstanceContainer, CommandContext commandContext) {
        for (String planItemDefinitionId : movePlanItemInstanceContainer.getMoveToPlanItemDefinitionIds()) {
            PlanItemInstanceEntity firstPlanItemInstance = movePlanItemInstanceContainer.getPlanItemInstances().get(0);
            CmmnModel cmmnModel = CaseDefinitionUtil.getCmmnModel(firstPlanItemInstance.getCaseDefinitionId());
            String currentPlanItemId = firstPlanItemInstance.getElementId();
            PlanItem currentPlanItem = this.resolvePlanItemFromCmmnModel(cmmnModel, currentPlanItemId, firstPlanItemInstance.getCaseDefinitionId());
            PlanItem newPlanItem = this.resolvePlanItemFromCmmnModelWithDefinitionId(cmmnModel, planItemDefinitionId, firstPlanItemInstance.getCaseDefinitionId());
            movePlanItemInstanceContainer.addMoveToPlanItem(currentPlanItem.getDefinitionRef(), currentPlanItem, newPlanItem);
        }
    }

    protected PlanItem resolvePlanItemFromCmmnModelWithDefinitionId(CmmnModel cmmnModel, String planItemDefinitionId, String caseDefinitionId) {
        PlanItem planItem = cmmnModel.findPlanItemByPlanItemDefinitionId(planItemDefinitionId);
        if (planItem == null) {
            throw new FlowableException("Cannot find plan item with definition id '" + planItemDefinitionId + "' in case definition with id '" + caseDefinitionId + "'");
        }
        return planItem;
    }

    protected PlanItem resolvePlanItemFromCmmnModel(CmmnModel cmmnModel, String planItemId, String caseDefinitionId) {
        PlanItem planItem = cmmnModel.findPlanItem(planItemId);
        if (planItem == null) {
            throw new FlowableException("Cannot find plan item '" + planItemId + "' in case definition with id '" + caseDefinitionId + "'");
        }
        return planItem;
    }

    protected void doMovePlanItemState(CaseInstanceChangeState caseInstanceChangeState, CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        Map<String, List<PlanItemInstance>> currentStages = this.resolveStagePlanItemInstances(caseInstanceChangeState.getCaseInstanceId(), commandContext);
        caseInstanceChangeState.setCurrentStageInstances(currentStages);
        CaseInstanceEntityManager caseInstanceEntityManager = CommandContextUtil.getCaseInstanceEntityManager(commandContext);
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)caseInstanceEntityManager.findById(caseInstanceChangeState.getCaseInstanceId());
        caseInstance.setVariables(caseInstanceChangeState.getCaseVariables());
        for (MovePlanItemInstanceEntityContainer movePlanItemInstanceContainer : caseInstanceChangeState.getMovePlanItemInstanceEntityContainers()) {
            this.prepareMovePlanItemInstanceEntityContainer(movePlanItemInstanceContainer, commandContext);
            List<PlanItemInstanceEntity> planItemInstancesToMove = movePlanItemInstanceContainer.getPlanItemInstances();
            List<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> moveToPlanItemMoveEntries = movePlanItemInstanceContainer.getMoveToPlanItems();
            HashSet<String> planItemInstanceIdsNotToDelete = new HashSet<String>();
            for (PlanItemInstanceEntity planItemInstance : planItemInstancesToMove) {
                planItemInstanceIdsNotToDelete.add(planItemInstance.getId());
                Date currentTime = cmmnEngineConfiguration.getClock().getCurrentTime();
                planItemInstance.setEndedTime(currentTime);
                planItemInstance.setTerminatedTime(currentTime);
                planItemInstance.setState("terminated");
                if (planItemInstance.getPlanItem().getPlanItemDefinition() instanceof HumanTask) {
                    TaskService taskService = CommandContextUtil.getTaskService(commandContext);
                    List taskEntities = taskService.findTasksBySubScopeIdScopeType(planItemInstance.getId(), "cmmn");
                    if (taskEntities == null || taskEntities.isEmpty()) {
                        throw new FlowableException("No task entity found for plan item instance " + planItemInstance.getId());
                    }
                    for (TaskEntity taskEntity : taskEntities) {
                        if (taskEntity.isDeleted()) continue;
                        TaskHelper.deleteTask(taskEntity, "Change plan item state", false, false);
                    }
                }
                PlanItemInstanceEntity continueParentPlanItemInstance = this.deleteParentPlanItemInstances(planItemInstance.getStageInstanceId(), moveToPlanItemMoveEntries, planItemInstanceIdsNotToDelete, commandContext);
                movePlanItemInstanceContainer.addContinueParentPlanItemInstance(planItemInstance.getId(), continueParentPlanItemInstance);
            }
            List<PlanItemInstanceEntity> newPlanItemInstances = this.createStagesAndPlanItemInstances(moveToPlanItemMoveEntries, planItemInstancesToMove, movePlanItemInstanceContainer, caseInstanceChangeState, commandContext);
            for (PlanItemInstanceEntity newPlanItemInstance : newPlanItemInstances) {
                CommandContextUtil.getAgenda().planStartPlanItemInstanceOperation(newPlanItemInstance, null);
            }
            CommandContextUtil.getAgenda(commandContext).planEvaluateCriteriaOperation(caseInstance.getId());
        }
    }

    protected abstract Map<String, List<PlanItemInstance>> resolveStagePlanItemInstances(String var1, CommandContext var2);

    protected abstract boolean isDirectPlanItemDefinitionMigration(PlanItemDefinition var1, PlanItemDefinition var2);

    protected PlanItemInstanceEntity deleteParentPlanItemInstances(String parentId, List<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> moveToPlanItemMoveEntries, Set<String> planItemInstanceIdsNotToDelete, CommandContext commandContext) {
        Stage parentStage;
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext);
        PlanItemInstanceEntity parentPlanItemInstance = null;
        if (parentId != null) {
            parentPlanItemInstance = (PlanItemInstanceEntity)planItemInstanceEntityManager.findById(parentId);
        }
        if (parentPlanItemInstance != null && parentPlanItemInstance.isStage() && !this.isStageAncestorOfAnyNewPlanItemDefinitions((parentStage = (Stage)parentPlanItemInstance.getPlanItem().getPlanItemDefinition()).getId(), moveToPlanItemMoveEntries)) {
            PlanItemInstanceEntity toDeleteParentExecution = this.resolveParentPlanItemInstanceToDelete(parentPlanItemInstance, moveToPlanItemMoveEntries);
            PlanItemInstanceEntity finalDeleteExecution = null;
            finalDeleteExecution = toDeleteParentExecution != null ? toDeleteParentExecution : parentPlanItemInstance;
            parentPlanItemInstance = finalDeleteExecution.getStagePlanItemInstanceEntity();
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            Date currentTime = cmmnEngineConfiguration.getClock().getCurrentTime();
            finalDeleteExecution.setEndedTime(currentTime);
            finalDeleteExecution.setTerminatedTime(currentTime);
            finalDeleteExecution.setState("terminated");
        }
        return parentPlanItemInstance;
    }

    protected boolean isStageContainerOfAnyPlanItemDefinition(String stageId, Collection<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> moveToPlanItems) {
        Optional<Stage> isUsed = moveToPlanItems.stream().map(MovePlanItemInstanceEntityContainer.PlanItemMoveEntry::getNewPlanItem).map(PlanItem::getPlanItemDefinition).map(CaseElement::getParentStage).filter(Objects::nonNull).filter(elementStage -> elementStage.getId().equals(stageId)).findAny();
        return isUsed.isPresent();
    }

    protected PlanItemInstanceEntity resolveParentPlanItemInstanceToDelete(PlanItemInstanceEntity planItemInstance, List<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> moveToPlanItems) {
        if (planItemInstance.getStageInstanceId() == null) {
            return null;
        }
        PlanItemInstanceEntity parentPlanItemInstance = planItemInstance.getStagePlanItemInstanceEntity();
        if (!this.isStageContainerOfAnyPlanItemDefinition(parentPlanItemInstance.getPlanItemDefinitionId(), moveToPlanItems)) {
            PlanItemInstanceEntity stageParentExecution = this.resolveParentPlanItemInstanceToDelete(parentPlanItemInstance, moveToPlanItems);
            if (stageParentExecution != null) {
                return stageParentExecution;
            }
            return parentPlanItemInstance;
        }
        return null;
    }

    protected List<PlanItemInstanceEntity> createStagesAndPlanItemInstances(List<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> moveToPlanItems, List<PlanItemInstanceEntity> movingPlanItemInstances, MovePlanItemInstanceEntityContainer movePlanItemInstanceEntityContainer, CaseInstanceChangeState caseInstanceChangeState, CommandContext commandContext) {
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext);
        HashMap<String, Stage> stagesToCreate = new HashMap<String, Stage>();
        for (MovePlanItemInstanceEntityContainer.PlanItemMoveEntry planItemMoveEntry : moveToPlanItems) {
            PlanItemDefinition newPlanItemDefinition = planItemMoveEntry.getNewPlanItem().getPlanItemDefinition();
            for (Stage stage = newPlanItemDefinition.getParentStage(); stage != null; stage = stage.getParentStage()) {
                if (caseInstanceChangeState.getCreatedStageInstances().containsKey(stage.getId()) || this.isStageAncestorOfAnyPlanItemInstance(stage.getId(), movingPlanItemInstances)) continue;
                stagesToCreate.put(stage.getId(), stage);
            }
        }
        PlanItemInstanceEntity defaultContinueParentPlanItemInstance = movePlanItemInstanceEntityContainer.getContinueParentPlanItemInstance(movingPlanItemInstances.get(0).getId());
        Set<String> movingPlanItemInstanceIds = movingPlanItemInstances.stream().map(PlanItemInstance::getId).collect(Collectors.toSet());
        for (Stage stage : stagesToCreate.values()) {
            if (caseInstanceChangeState.getCreatedStageInstances().containsKey(stage.getId())) continue;
            PlanItemInstanceEntity stageInstance = this.createStageHierarchy(stage, defaultContinueParentPlanItemInstance, stagesToCreate, movingPlanItemInstanceIds, caseInstanceChangeState, movePlanItemInstanceEntityContainer, commandContext);
            caseInstanceChangeState.addCreatedStageInstance(stage.getId(), stageInstance);
        }
        ArrayList<PlanItemInstanceEntity> newChildPlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
        for (MovePlanItemInstanceEntityContainer.PlanItemMoveEntry planItemMoveEntry : moveToPlanItems) {
            PlanItem newPlanItem = planItemMoveEntry.getNewPlanItem();
            PlanItemDefinition newPlanItemDefinition = newPlanItem.getPlanItemDefinition();
            PlanItemInstanceEntity parentPlanItemInstance = null;
            parentPlanItemInstance = newPlanItemDefinition.getParentStage() != null && caseInstanceChangeState.getCreatedStageInstances().containsKey(newPlanItemDefinition.getParentStage().getId()) ? caseInstanceChangeState.getCreatedStageInstances().get(newPlanItemDefinition.getParentStage().getId()) : defaultContinueParentPlanItemInstance;
            List<PlanItemInstanceEntity> existingPlanItemInstances = planItemInstanceEntityManager.findByCaseInstanceIdAndPlanItemId(movePlanItemInstanceEntityContainer.getCaseInstanceId(), newPlanItem.getId());
            PlanItemInstanceEntity newPlanItemInstance = null;
            if (!existingPlanItemInstances.isEmpty()) {
                for (PlanItemInstanceEntity existingPlanItemInstance : existingPlanItemInstances) {
                    if (!"available".equals(existingPlanItemInstance.getState())) continue;
                    newPlanItemInstance = existingPlanItemInstance;
                }
            }
            if (newPlanItemInstance == null) {
                newPlanItemInstance = planItemInstanceEntityManager.createChildPlanItemInstance(newPlanItem, movePlanItemInstanceEntityContainer.getCaseDefinitionId(), movePlanItemInstanceEntityContainer.getCaseInstanceId(), parentPlanItemInstance != null ? parentPlanItemInstance.getId() : null, movePlanItemInstanceEntityContainer.getTenantId(), true);
                if (newPlanItem.getParentStage() != null) {
                    for (PlanItem stagePlanItem : newPlanItem.getParentStage().getPlanItems()) {
                        if (stagePlanItem.getId().equals(newPlanItem.getId())) continue;
                        PlanItemInstanceEntity childStagePlanItemInstance = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createChildPlanItemInstance(stagePlanItem, newPlanItemInstance.getCaseDefinitionId(), newPlanItemInstance.getCaseInstanceId(), newPlanItemInstance.getStageInstanceId(), newPlanItemInstance.getTenantId(), true);
                        CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceOperation(childStagePlanItemInstance);
                    }
                }
            }
            if (movePlanItemInstanceEntityContainer.getNewAssigneeId() != null && newPlanItemDefinition instanceof HumanTask) {
                this.handleHumanTaskNewAssignee(newPlanItemInstance, movePlanItemInstanceEntityContainer.getNewAssigneeId(), commandContext);
            }
            newChildPlanItemInstances.add(newPlanItemInstance);
        }
        return newChildPlanItemInstances;
    }

    protected boolean isStageAncestorOfAnyPlanItemInstance(String stageId, List<PlanItemInstanceEntity> planItemInstances) {
        for (PlanItemInstanceEntity planItemInstance : planItemInstances) {
            PlanItemDefinition planItemDefinition = planItemInstance.getPlanItem().getPlanItemDefinition();
            if (!this.isStageAncestor(stageId, planItemDefinition)) continue;
            return true;
        }
        return false;
    }

    protected boolean isStageAncestorOfAnyNewPlanItemDefinitions(String stageId, List<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> planItems) {
        for (MovePlanItemInstanceEntityContainer.PlanItemMoveEntry planItemMoveEntry : planItems) {
            if (!this.isStageAncestor(stageId, planItemMoveEntry.getNewPlanItem().getPlanItemDefinition())) continue;
            return true;
        }
        return false;
    }

    private boolean isStageAncestor(String stageId, PlanItemDefinition planItemDefinition) {
        while (planItemDefinition.getParentStage() != null) {
            String currentStageId = planItemDefinition.getParentStage().getId();
            if (currentStageId != null && currentStageId.equals(stageId)) {
                return true;
            }
            planItemDefinition = planItemDefinition.getParentStage();
        }
        return false;
    }

    protected PlanItemInstanceEntity createStageHierarchy(Stage stage, PlanItemInstanceEntity defaultParentPlanItemInstance, Map<String, Stage> stagesToCreate, Set<String> movingPlanItemInstanceIds, CaseInstanceChangeState caseInstanceChangeState, MovePlanItemInstanceEntityContainer movePlanItemInstanceEntityContainer, CommandContext commandContext) {
        if (caseInstanceChangeState.getCurrentStageInstances().containsKey(stage.getId())) {
            return (PlanItemInstanceEntity)caseInstanceChangeState.getCurrentStageInstances().get(stage.getId()).get(0);
        }
        if (caseInstanceChangeState.getCreatedStageInstances().containsKey(stage.getId())) {
            return caseInstanceChangeState.getCreatedStageInstances().get(stage.getId());
        }
        PlanItemInstanceEntity parentStageInstance = defaultParentPlanItemInstance;
        if (stage.getParentStage() != null && !stage.getParentStage().isPlanModel()) {
            parentStageInstance = this.createStageHierarchy(stage.getParentStage(), defaultParentPlanItemInstance, stagesToCreate, movingPlanItemInstanceIds, caseInstanceChangeState, movePlanItemInstanceEntityContainer, commandContext);
            caseInstanceChangeState.getCreatedStageInstances().put(stage.getParentStage().getId(), parentStageInstance);
        }
        PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext);
        List<PlanItemInstanceEntity> existingPlanItemInstances = planItemInstanceEntityManager.findByCaseInstanceIdAndPlanItemId(movePlanItemInstanceEntityContainer.getCaseInstanceId(), stage.getPlanItem().getId());
        PlanItemInstanceEntity newPlanItemInstance = null;
        if (!existingPlanItemInstances.isEmpty()) {
            for (PlanItemInstanceEntity existingPlanItemInstance : existingPlanItemInstances) {
                if (!"available".equals(existingPlanItemInstance.getState())) continue;
                newPlanItemInstance = existingPlanItemInstance;
            }
        }
        if (newPlanItemInstance == null) {
            newPlanItemInstance = planItemInstanceEntityManager.createChildPlanItemInstance(stage.getPlanItem(), movePlanItemInstanceEntityContainer.getCaseDefinitionId(), movePlanItemInstanceEntityContainer.getCaseInstanceId(), parentStageInstance != null ? parentStageInstance.getId() : null, movePlanItemInstanceEntityContainer.getTenantId(), true);
        }
        CommandContextUtil.getAgenda().planStartPlanItemInstanceOperation(newPlanItemInstance, null);
        return newPlanItemInstance;
    }

    protected void handleHumanTaskNewAssignee(PlanItemInstanceEntity taskPlanItemInstance, String newAssigneeId, CommandContext commandContext) {
        TaskService taskService = CommandContextUtil.getTaskService(commandContext);
        TaskEntityImpl task = (TaskEntityImpl)((TaskQuery)((TaskQuery)taskService.createTaskQuery().subScopeId(taskPlanItemInstance.getId())).scopeType("cmmn")).singleResult();
        TaskHelper.changeTaskAssignee((TaskEntity)task, newAssigneeId);
    }

    protected boolean isExpression(String variableName) {
        return variableName.startsWith("${") || variableName.startsWith("#{");
    }

    protected CaseDefinition resolveCaseDefinition(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId, CommandContext commandContext) {
        CaseDefinitionEntityManager caseDefinitionEntityManager = CommandContextUtil.getCaseDefinitionEntityManager(commandContext);
        Object caseDefinition = null;
        caseDefinition = caseDefinitionVersion != null ? caseDefinitionEntityManager.findCaseDefinitionByKeyAndVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId) : (tenantId == null || "".equals(tenantId) ? caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey) : caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId));
        if (caseDefinition == null) {
            CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager();
            caseDefinition = tenantId == null || "".equals(tenantId) ? deploymentManager.findDeployedLatestCaseDefinitionByKey(caseDefinitionKey) : deploymentManager.findDeployedLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        }
        return caseDefinition;
    }
}

