/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.repository;

import java.io.Serializable;
import java.util.List;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.api.repository.CmmnDeploymentQuery;
import org.flowable.cmmn.engine.impl.repository.CmmnDeploymentQueryProperty;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.AbstractQuery;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;

public class CmmnDeploymentQueryImpl
extends AbstractQuery<CmmnDeploymentQuery, CmmnDeployment>
implements CmmnDeploymentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected String name;
    protected String nameLike;
    protected String category;
    protected String categoryNotEquals;
    protected String key;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String parentDeploymentId;
    protected String parentDeploymentIdLike;
    protected List<String> parentDeploymentIds;
    protected boolean latest;

    public CmmnDeploymentQueryImpl() {
    }

    public CmmnDeploymentQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public CmmnDeploymentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public CmmnDeploymentQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("Deployment id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentIds(List<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("Deployment ids is null");
        }
        this.deploymentIds = deploymentIds;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentName(String deploymentName) {
        if (deploymentName == null) {
            throw new FlowableIllegalArgumentException("deploymentName is null");
        }
        this.name = deploymentName;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("deploymentNameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentCategory(String deploymentCategory) {
        if (deploymentCategory == null) {
            throw new FlowableIllegalArgumentException("deploymentCategory is null");
        }
        this.category = deploymentCategory;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentCategoryNotEquals(String deploymentCategoryNotEquals) {
        if (deploymentCategoryNotEquals == null) {
            throw new FlowableIllegalArgumentException("deploymentCategoryExclude is null");
        }
        this.categoryNotEquals = deploymentCategoryNotEquals;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentKey(String deploymentKey) {
        if (deploymentKey == null) {
            throw new FlowableIllegalArgumentException("deploymentKey is null");
        }
        this.key = deploymentKey;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("deploymentTenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("deploymentTenantIdLike is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public CmmnDeploymentQueryImpl deploymentWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public CmmnDeploymentQueryImpl parentDeploymentId(String parentDeploymentId) {
        if (parentDeploymentId == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentId is null");
        }
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public CmmnDeploymentQueryImpl parentDeploymentIdLike(String parentDeploymentIdLike) {
        if (parentDeploymentIdLike == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentIdLike is null");
        }
        this.parentDeploymentIdLike = parentDeploymentIdLike;
        return this;
    }

    public CmmnDeploymentQueryImpl parentDeploymentIds(List<String> parentDeploymentIds) {
        if (parentDeploymentIds == null) {
            throw new FlowableIllegalArgumentException("parentDeploymentIds is null");
        }
        this.parentDeploymentIds = parentDeploymentIds;
        return this;
    }

    public CmmnDeploymentQueryImpl latest() {
        if (this.key == null) {
            throw new FlowableIllegalArgumentException("latest can only be used together with a deployment key");
        }
        this.latest = true;
        return this;
    }

    public CmmnDeploymentQuery orderByDeploymentId() {
        return (CmmnDeploymentQuery)this.orderBy(CmmnDeploymentQueryProperty.DEPLOYMENT_ID);
    }

    public CmmnDeploymentQuery orderByDeploymenTime() {
        return (CmmnDeploymentQuery)this.orderBy(CmmnDeploymentQueryProperty.DEPLOY_TIME);
    }

    public CmmnDeploymentQuery orderByDeploymentName() {
        return (CmmnDeploymentQuery)this.orderBy(CmmnDeploymentQueryProperty.DEPLOYMENT_NAME);
    }

    public CmmnDeploymentQuery orderByTenantId() {
        return (CmmnDeploymentQuery)this.orderBy(CmmnDeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getCmmnDeploymentEntityManager(commandContext).findDeploymentCountByQueryCriteria(this);
    }

    public List<CmmnDeployment> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getCmmnDeploymentEntityManager(commandContext).findDeploymentsByQueryCriteria(this);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public List<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getKey() {
        return this.key;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

