/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.HistoricVariableService;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class VariableCreatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public String getType() {
        return "cmmn-variable-created";
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricVariableService historicVariableService = CommandContextUtil.getHistoricVariableService();
        HistoricVariableInstanceEntity historicVariableInstanceEntity = historicVariableService.createHistoricVariableInstance();
        historicVariableInstanceEntity.setId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
        historicVariableInstanceEntity.setScopeId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"scopeId"));
        historicVariableInstanceEntity.setSubScopeId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"subScopeId"));
        historicVariableInstanceEntity.setScopeType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"scopeType"));
        historicVariableInstanceEntity.setTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskId"));
        historicVariableInstanceEntity.setRevision(AsyncHistoryJsonUtil.getIntegerFromJson((ObjectNode)historicalData, (String)"revision").intValue());
        historicVariableInstanceEntity.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"name"));
        VariableTypes variableTypes = CommandContextUtil.getCmmnEngineConfiguration().getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableType"));
        historicVariableInstanceEntity.setVariableType(variableType);
        historicVariableInstanceEntity.setTextValue(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue"));
        historicVariableInstanceEntity.setTextValue2(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue2"));
        historicVariableInstanceEntity.setDoubleValue(AsyncHistoryJsonUtil.getDoubleFromJson((ObjectNode)historicalData, (String)"variableDoubleValue"));
        historicVariableInstanceEntity.setLongValue(AsyncHistoryJsonUtil.getLongFromJson((ObjectNode)historicalData, (String)"variableLongValue"));
        String variableBytes = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicVariableInstanceEntity.setBytes(Base64.getDecoder().decode(variableBytes));
        }
        Date time = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime");
        historicVariableInstanceEntity.setCreateTime(time);
        historicVariableInstanceEntity.setLastUpdatedTime(time);
        historicVariableService.insertHistoricVariableInstance(historicVariableInstanceEntity);
    }
}

