/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class RemoveLocalVariableCmd
implements Command<Void> {
    protected String planItemInstanceId;
    protected String variableName;

    public RemoveLocalVariableCmd(String planItemInstanceId, String variableName) {
        this.planItemInstanceId = planItemInstanceId;
        this.variableName = variableName;
    }

    public Void execute(CommandContext commandContext) {
        if (this.planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("planItemInstanceId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(this.planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No plan item instance found for id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        planItemInstanceEntity.removeVariable(this.variableName);
        return null;
    }
}

