/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeleteHistoricCaseInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseInstanceId;

    public DeleteHistoricCaseInstanceCmd(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public Object execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        HistoricCaseInstance instance = (HistoricCaseInstance)CommandContextUtil.getHistoricCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (instance == null) {
            throw new FlowableObjectNotFoundException("No historic case instance found with id: " + this.caseInstanceId, HistoricCaseInstance.class);
        }
        if (instance.getEndTime() == null) {
            throw new FlowableException("Case instance is still running, cannot delete historic case instance: " + this.caseInstanceId);
        }
        CommandContextUtil.getCmmnHistoryManager(commandContext).recordHistoricCaseInstanceDeleted(this.caseInstanceId);
        return null;
    }
}

