/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Task;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class ActivateAsyncPlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public ActivateAsyncPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    protected String getLifeCycleTransition() {
        return "async-activate";
    }

    @Override
    protected String getNewState() {
        return "async-active";
    }

    @Override
    protected void internalExecute() {
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceStarted(this.planItemInstanceEntity);
        this.createAsyncJob((Task)this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition());
    }

    protected void createAsyncJob(Task task) {
        JobService jobService = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setScopeId(this.planItemInstanceEntity.getCaseInstanceId());
        job.setSubScopeId(this.planItemInstanceEntity.getId());
        job.setScopeDefinitionId(this.planItemInstanceEntity.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setTenantId(this.planItemInstanceEntity.getTenantId());
        job.setJobHandlerType("cmmn-async-activate-plan-item-instance");
        jobService.createAsyncJob(job, task.isExclusive());
        jobService.scheduleAsyncJob(job);
    }
}

