/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel.tree;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.job.config.Operator;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class TreeNode
implements ToXContentObject {
    public static final String NAME = "tree_node";
    public static final ParseField DECISION_TYPE = new ParseField("decision_type", new String[0]);
    public static final ParseField THRESHOLD = new ParseField("threshold", new String[0]);
    public static final ParseField LEFT_CHILD = new ParseField("left_child", new String[0]);
    public static final ParseField RIGHT_CHILD = new ParseField("right_child", new String[0]);
    public static final ParseField DEFAULT_LEFT = new ParseField("default_left", new String[0]);
    public static final ParseField SPLIT_FEATURE = new ParseField("split_feature", new String[0]);
    public static final ParseField NODE_INDEX = new ParseField("node_index", new String[0]);
    public static final ParseField SPLIT_GAIN = new ParseField("split_gain", new String[0]);
    public static final ParseField LEAF_VALUE = new ParseField("leaf_value", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("tree_node", true, () -> new Builder());
    private final Operator operator;
    private final Double threshold;
    private final Integer splitFeature;
    private final int nodeIndex;
    private final Double splitGain;
    private final Double leafValue;
    private final Boolean defaultLeft;
    private final Integer leftChild;
    private final Integer rightChild;

    public static Builder fromXContent(XContentParser parser) {
        return (Builder)PARSER.apply(parser, null);
    }

    TreeNode(Operator operator, Double threshold, Integer splitFeature, int nodeIndex, Double splitGain, Double leafValue, Boolean defaultLeft, Integer leftChild, Integer rightChild) {
        this.operator = operator;
        this.threshold = threshold;
        this.splitFeature = splitFeature;
        this.nodeIndex = nodeIndex;
        this.splitGain = splitGain;
        this.leafValue = leafValue;
        this.defaultLeft = defaultLeft;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Integer getSplitFeature() {
        return this.splitFeature;
    }

    public Integer getNodeIndex() {
        return this.nodeIndex;
    }

    public Double getSplitGain() {
        return this.splitGain;
    }

    public Double getLeafValue() {
        return this.leafValue;
    }

    public Boolean isDefaultLeft() {
        return this.defaultLeft;
    }

    public Integer getLeftChild() {
        return this.leftChild;
    }

    public Integer getRightChild() {
        return this.rightChild;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addOptionalField(builder, DECISION_TYPE, (Object)this.operator);
        this.addOptionalField(builder, THRESHOLD, this.threshold);
        this.addOptionalField(builder, SPLIT_FEATURE, this.splitFeature);
        this.addOptionalField(builder, SPLIT_GAIN, this.splitGain);
        this.addOptionalField(builder, NODE_INDEX, this.nodeIndex);
        this.addOptionalField(builder, LEAF_VALUE, this.leafValue);
        this.addOptionalField(builder, DEFAULT_LEFT, this.defaultLeft);
        this.addOptionalField(builder, LEFT_CHILD, this.leftChild);
        this.addOptionalField(builder, RIGHT_CHILD, this.rightChild);
        builder.endObject();
        return builder;
    }

    private void addOptionalField(XContentBuilder builder, ParseField field, Object value) throws IOException {
        if (value != null) {
            builder.field(field.getPreferredName(), value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNode that = (TreeNode)o;
        return Objects.equals((Object)this.operator, (Object)that.operator) && Objects.equals(this.threshold, that.threshold) && Objects.equals(this.splitFeature, that.splitFeature) && Objects.equals(this.nodeIndex, that.nodeIndex) && Objects.equals(this.splitGain, that.splitGain) && Objects.equals(this.leafValue, that.leafValue) && Objects.equals(this.defaultLeft, that.defaultLeft) && Objects.equals(this.leftChild, that.leftChild) && Objects.equals(this.rightChild, that.rightChild);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.threshold, this.splitFeature, this.splitGain, this.nodeIndex, this.leafValue, this.defaultLeft, this.leftChild, this.rightChild});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Builder builder(int nodeIndex) {
        return new Builder(nodeIndex);
    }

    static {
        PARSER.declareDouble(Builder::setThreshold, THRESHOLD);
        PARSER.declareField(Builder::setOperator, p -> Operator.fromString(p.text()), DECISION_TYPE, ObjectParser.ValueType.STRING);
        PARSER.declareInt(Builder::setLeftChild, LEFT_CHILD);
        PARSER.declareInt(Builder::setRightChild, RIGHT_CHILD);
        PARSER.declareBoolean(Builder::setDefaultLeft, DEFAULT_LEFT);
        PARSER.declareInt(Builder::setSplitFeature, SPLIT_FEATURE);
        PARSER.declareInt(Builder::setNodeIndex, NODE_INDEX);
        PARSER.declareDouble(Builder::setSplitGain, SPLIT_GAIN);
        PARSER.declareDouble(Builder::setLeafValue, LEAF_VALUE);
    }

    public static class Builder {
        private Operator operator;
        private Double threshold;
        private Integer splitFeature;
        private int nodeIndex;
        private Double splitGain;
        private Double leafValue;
        private Boolean defaultLeft;
        private Integer leftChild;
        private Integer rightChild;

        public Builder(int nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        private Builder() {
        }

        public Builder setOperator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public Builder setThreshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder setSplitFeature(Integer splitFeature) {
            this.splitFeature = splitFeature;
            return this;
        }

        public Builder setNodeIndex(int nodeIndex) {
            this.nodeIndex = nodeIndex;
            return this;
        }

        public Builder setSplitGain(Double splitGain) {
            this.splitGain = splitGain;
            return this;
        }

        public Builder setLeafValue(Double leafValue) {
            this.leafValue = leafValue;
            return this;
        }

        public Builder setDefaultLeft(Boolean defaultLeft) {
            this.defaultLeft = defaultLeft;
            return this;
        }

        public Builder setLeftChild(Integer leftChild) {
            this.leftChild = leftChild;
            return this;
        }

        public Integer getLeftChild() {
            return this.leftChild;
        }

        public Builder setRightChild(Integer rightChild) {
            this.rightChild = rightChild;
            return this;
        }

        public Integer getRightChild() {
            return this.rightChild;
        }

        public TreeNode build() {
            return new TreeNode(this.operator, this.threshold, this.splitFeature, this.nodeIndex, this.splitGain, this.leafValue, this.defaultLeft, this.leftChild, this.rightChild);
        }
    }
}

