/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalysis;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class Regression
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    static final ParseField DEPENDENT_VARIABLE = new ParseField("dependent_variable", new String[0]);
    static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    static final ParseField ETA = new ParseField("eta", new String[0]);
    static final ParseField MAXIMUM_NUMBER_TREES = new ParseField("maximum_number_trees", new String[0]);
    static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    static final ParseField PREDICTION_FIELD_NAME = new ParseField("prediction_field_name", new String[0]);
    static final ParseField TRAINING_PERCENT = new ParseField("training_percent", new String[0]);
    static final ParseField RANDOMIZE_SEED = new ParseField("randomize_seed", new String[0]);
    private static final ConstructingObjectParser<Regression, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new Regression((String)a[0], (Double)a[1], (Double)a[2], (Double)a[3], (Integer)a[4], (Double)a[5], (Integer)a[6], (String)a[7], (Double)a[8], (Long)a[9]));
    private final String dependentVariable;
    private final Double lambda;
    private final Double gamma;
    private final Double eta;
    private final Integer maximumNumberTrees;
    private final Double featureBagFraction;
    private final Integer numTopFeatureImportanceValues;
    private final String predictionFieldName;
    private final Double trainingPercent;
    private final Long randomizeSeed;

    public static Regression fromXContent(XContentParser parser) {
        return (Regression)PARSER.apply(parser, null);
    }

    public static Builder builder(String dependentVariable) {
        return new Builder(dependentVariable);
    }

    private Regression(String dependentVariable, @Nullable Double lambda, @Nullable Double gamma, @Nullable Double eta, @Nullable Integer maximumNumberTrees, @Nullable Double featureBagFraction, @Nullable Integer numTopFeatureImportanceValues, @Nullable String predictionFieldName, @Nullable Double trainingPercent, @Nullable Long randomizeSeed) {
        this.dependentVariable = Objects.requireNonNull(dependentVariable);
        this.lambda = lambda;
        this.gamma = gamma;
        this.eta = eta;
        this.maximumNumberTrees = maximumNumberTrees;
        this.featureBagFraction = featureBagFraction;
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
        this.predictionFieldName = predictionFieldName;
        this.trainingPercent = trainingPercent;
        this.randomizeSeed = randomizeSeed;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public String getDependentVariable() {
        return this.dependentVariable;
    }

    public Double getLambda() {
        return this.lambda;
    }

    public Double getGamma() {
        return this.gamma;
    }

    public Double getEta() {
        return this.eta;
    }

    public Integer getMaximumNumberTrees() {
        return this.maximumNumberTrees;
    }

    public Double getFeatureBagFraction() {
        return this.featureBagFraction;
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public String getPredictionFieldName() {
        return this.predictionFieldName;
    }

    public Double getTrainingPercent() {
        return this.trainingPercent;
    }

    public Long getRandomizeSeed() {
        return this.randomizeSeed;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.maximumNumberTrees != null) {
            builder.field(MAXIMUM_NUMBER_TREES.getPreferredName(), this.maximumNumberTrees);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        if (this.predictionFieldName != null) {
            builder.field(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        if (this.trainingPercent != null) {
            builder.field(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        }
        if (this.randomizeSeed != null) {
            builder.field(RANDOMIZE_SEED.getPreferredName(), this.randomizeSeed);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.dependentVariable, this.lambda, this.gamma, this.eta, this.maximumNumberTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.predictionFieldName, this.trainingPercent, this.randomizeSeed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regression that = (Regression)o;
        return Objects.equals(this.dependentVariable, that.dependentVariable) && Objects.equals(this.lambda, that.lambda) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.eta, that.eta) && Objects.equals(this.maximumNumberTrees, that.maximumNumberTrees) && Objects.equals(this.featureBagFraction, that.featureBagFraction) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues) && Objects.equals(this.predictionFieldName, that.predictionFieldName) && Objects.equals(this.trainingPercent, that.trainingPercent) && Objects.equals(this.randomizeSeed, that.randomizeSeed);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DEPENDENT_VARIABLE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAXIMUM_NUMBER_TREES);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTION_FIELD_NAME);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TRAINING_PERCENT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), RANDOMIZE_SEED);
    }

    public static class Builder {
        private String dependentVariable;
        private Double lambda;
        private Double gamma;
        private Double eta;
        private Integer maximumNumberTrees;
        private Double featureBagFraction;
        private Integer numTopFeatureImportanceValues;
        private String predictionFieldName;
        private Double trainingPercent;
        private Long randomizeSeed;

        private Builder(String dependentVariable) {
            this.dependentVariable = Objects.requireNonNull(dependentVariable);
        }

        public Builder setLambda(Double lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder setGamma(Double gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder setEta(Double eta) {
            this.eta = eta;
            return this;
        }

        public Builder setMaximumNumberTrees(Integer maximumNumberTrees) {
            this.maximumNumberTrees = maximumNumberTrees;
            return this;
        }

        public Builder setFeatureBagFraction(Double featureBagFraction) {
            this.featureBagFraction = featureBagFraction;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setPredictionFieldName(String predictionFieldName) {
            this.predictionFieldName = predictionFieldName;
            return this;
        }

        public Builder setTrainingPercent(Double trainingPercent) {
            this.trainingPercent = trainingPercent;
            return this;
        }

        public Builder setRandomizeSeed(Long randomizeSeed) {
            this.randomizeSeed = randomizeSeed;
            return this;
        }

        public Regression build() {
            return new Regression(this.dependentVariable, this.lambda, this.gamma, this.eta, this.maximumNumberTrees, this.featureBagFraction, this.numTopFeatureImportanceValues, this.predictionFieldName, this.trainingPercent, this.randomizeSeed);
        }
    }
}

