/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.paho.mqttv5.client.websocket.WebSocketFrame;
import org.eclipse.paho.mqttv5.client.websocket.WebSocketNetworkModule;
import org.eclipse.paho.mqttv5.client.websocket.WebSocketSecureNetworkModule;

class ExtendedByteArrayOutputStream
extends ByteArrayOutputStream {
    final WebSocketNetworkModule webSocketNetworkModule;
    final WebSocketSecureNetworkModule webSocketSecureNetworkModule;

    ExtendedByteArrayOutputStream(WebSocketNetworkModule module) {
        this.webSocketNetworkModule = module;
        this.webSocketSecureNetworkModule = null;
    }

    ExtendedByteArrayOutputStream(WebSocketSecureNetworkModule module) {
        this.webSocketNetworkModule = null;
        this.webSocketSecureNetworkModule = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        ByteBuffer byteBuffer;
        ExtendedByteArrayOutputStream extendedByteArrayOutputStream = this;
        synchronized (extendedByteArrayOutputStream) {
            byteBuffer = ByteBuffer.wrap(this.toByteArray());
            this.reset();
        }
        WebSocketFrame frame = new WebSocketFrame(2, true, byteBuffer.array());
        byte[] rawFrame = frame.encodeFrame();
        this.getSocketOutputStream().write(rawFrame);
        this.getSocketOutputStream().flush();
    }

    OutputStream getSocketOutputStream() throws IOException {
        if (this.webSocketNetworkModule != null) {
            return this.webSocketNetworkModule.getSocketOutputStream();
        }
        if (this.webSocketSecureNetworkModule != null) {
            return this.webSocketSecureNetworkModule.getSocketOutputStream();
        }
        return null;
    }
}

