/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.send;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.node.TimestampedLwM2mNodes;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.SendRequest;
import org.eclipse.leshan.core.request.UplinkRequest;
import org.eclipse.leshan.core.request.exception.InvalidRequestException;
import org.eclipse.leshan.core.response.SendResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.server.profile.ClientProfileProvider;
import org.eclipse.leshan.server.request.UplinkRequestReceiver;

public class SendResource
extends LwM2mCoapResource {
    private final LwM2mDecoder decoder;
    private final UplinkRequestReceiver receiver;
    private final ClientProfileProvider profileProvider;

    public SendResource(UplinkRequestReceiver receiver, LwM2mDecoder decoder, ClientProfileProvider profileProvider, IdentityHandlerProvider identityHandlerProvider) {
        super("dp", identityHandlerProvider);
        this.decoder = decoder;
        this.receiver = receiver;
        this.profileProvider = profileProvider;
    }

    public void handlePOST(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        IpPeer sender = this.getForeignPeerIdentity(exchange.advanced(), (Message)coapRequest);
        ClientProfile clientProfile = this.profileProvider.getProfile(sender.getIdentity());
        if (clientProfile == null) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "no registration found");
            return;
        }
        try {
            byte[] payload = exchange.getRequestPayload();
            ContentFormat contentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
            if (!this.decoder.isSupported(contentFormat)) {
                exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Unsupported content format");
                this.receiver.onError((LwM2mPeer)sender, clientProfile, (Exception)new InvalidRequestException("Unsupported content format [%s] in [%s] from [%s]", new Object[]{contentFormat, coapRequest, sender}), SendRequest.class, exchange.advanced().getEndpoint().getUri());
                return;
            }
            TimestampedLwM2mNodes data = this.decoder.decodeTimestampedNodes(payload, contentFormat, clientProfile.getModel());
            SendRequest sendRequest = new SendRequest(contentFormat, data, (Object)coapRequest);
            SendableResponse sendableResponse = this.receiver.requestReceived((LwM2mPeer)sender, clientProfile, (UplinkRequest)sendRequest, exchange.advanced().getEndpoint().getUri());
            SendResponse response = (SendResponse)sendableResponse.getResponse();
            if (response.isSuccess()) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                sendableResponse.sent();
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            sendableResponse.sent();
            return;
        }
        catch (CodecException e) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Invalid Payload");
            this.receiver.onError((LwM2mPeer)sender, clientProfile, (Exception)new InvalidRequestException((Throwable)e, "Invalid payload in [%s] from [%s]", new Object[]{coapRequest, sender}), SendRequest.class, exchange.advanced().getEndpoint().getUri());
            return;
        }
        catch (RuntimeException e) {
            this.receiver.onError((LwM2mPeer)sender, clientProfile, (Exception)e, SendRequest.class, exchange.advanced().getEndpoint().getUri());
            throw e;
        }
    }
}

