/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import java.util.Collection;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.leshan.core.californium.ObserveUtil;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelCompositeObservationRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.util.StringUtils;
import org.eclipse.leshan.server.request.LowerLayerConfig;

public class CoapRequestBuilder
implements DownlinkRequestVisitor {
    private Request coapRequest;
    private final LwM2mPeer destination;
    private final String rootPath;
    private final String registrationId;
    private final String endpoint;
    private final boolean allowConnectionInitiation;
    private final LwM2mModel model;
    private final LwM2mEncoder encoder;
    private final LowerLayerConfig lowerLayerConfig;
    private final IdentityHandler identityHandler;

    public CoapRequestBuilder(LwM2mPeer destination, String rootPath, String registrationId, String endpoint, LwM2mModel model, LwM2mEncoder encoder, boolean allowConnectionInitiation, LowerLayerConfig lowerLayerConfig, IdentityHandler identityHandler) {
        this.destination = destination;
        this.rootPath = rootPath;
        this.endpoint = endpoint;
        this.registrationId = registrationId;
        this.model = model;
        this.encoder = encoder;
        this.allowConnectionInitiation = allowConnectionInitiation;
        this.lowerLayerConfig = lowerLayerConfig;
        this.identityHandler = identityHandler;
    }

    public void visit(ReadRequest request) {
        this.coapRequest = Request.newGet();
        if (request.getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getContentFormat().getCode());
        }
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(DiscoverRequest request) {
        this.coapRequest = Request.newGet();
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.coapRequest.getOptions().setAccept(40);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(WriteRequest request) {
        this.coapRequest = request.isReplaceRequest() ? Request.newPut() : Request.newPost();
        ContentFormat format = request.getContentFormat();
        this.coapRequest.getOptions().setContentFormat(format.getCode());
        this.coapRequest.setPayload(this.encoder.encode((LwM2mNode)request.getNode(), format, request.getPath(), this.model));
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(WriteAttributesRequest request) {
        this.coapRequest = Request.newPut();
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        for (String query : request.getAttributes().toQueryParams()) {
            this.coapRequest.getOptions().addUriQuery(query);
        }
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(ExecuteRequest request) {
        this.coapRequest = Request.newPost();
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        String payload = request.getArguments().serialize();
        if (payload != null) {
            this.coapRequest.setPayload(payload);
            this.coapRequest.getOptions().setContentFormat(0);
        }
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(CreateRequest request) {
        this.coapRequest = Request.newPost();
        this.coapRequest.getOptions().setContentFormat(request.getContentFormat().getCode());
        Object node = request.unknownObjectInstanceId() ? new LwM2mObjectInstance((Collection)request.getResources()) : new LwM2mObject(request.getPath().getObjectId().intValue(), (Collection)request.getObjectInstances());
        this.coapRequest.setPayload(this.encoder.encode((LwM2mNode)node, request.getContentFormat(), request.getPath(), this.model));
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(DeleteRequest request) {
        this.coapRequest = Request.newDelete();
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(ObserveRequest request) {
        this.coapRequest = Request.newGet();
        if (request.getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getContentFormat().getCode());
        }
        this.coapRequest.setObserve();
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.coapRequest.setUserContext(ObserveUtil.createCoapObserveRequestContext((String)this.endpoint, (String)this.registrationId, (ObserveRequest)request));
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(CancelObservationRequest request) {
        this.coapRequest = Request.newGet();
        this.coapRequest.setObserveCancel();
        this.coapRequest.setToken(request.getObservation().getId().getBytes());
        if (request.getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getContentFormat().getCode());
        }
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(ReadCompositeRequest request) {
        this.coapRequest = Request.newFetch();
        this.coapRequest.getOptions().setContentFormat(request.getRequestContentFormat().getCode());
        this.coapRequest.setPayload(this.encoder.encodePaths(request.getPaths(), request.getRequestContentFormat()));
        if (request.getResponseContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getResponseContentFormat().getCode());
        }
        this.setURI(this.coapRequest, LwM2mPath.ROOTPATH);
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(ObserveCompositeRequest request) {
        this.coapRequest = Request.newFetch();
        this.coapRequest.getOptions().setContentFormat(request.getRequestContentFormat().getCode());
        this.coapRequest.setPayload(this.encoder.encodePaths(request.getPaths(), request.getRequestContentFormat()));
        if (request.getResponseContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getResponseContentFormat().getCode());
        }
        this.coapRequest.setObserve();
        this.setURI(this.coapRequest, LwM2mPath.ROOTPATH);
        this.setSecurityContext(this.coapRequest);
        this.coapRequest.setUserContext(ObserveUtil.createCoapObserveCompositeRequestContext((String)this.endpoint, (String)this.registrationId, (ObserveCompositeRequest)request));
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(CancelCompositeObservationRequest request) {
        this.coapRequest = Request.newFetch();
        this.coapRequest.setObserveCancel();
        this.coapRequest.setToken(request.getObservation().getId().getBytes());
        this.coapRequest.getOptions().setContentFormat(request.getRequestContentFormat().getCode());
        this.coapRequest.setPayload(this.encoder.encodePaths(request.getPaths(), request.getRequestContentFormat()));
        if (request.getResponseContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getResponseContentFormat().getCode());
        }
        this.setURI(this.coapRequest, LwM2mPath.ROOTPATH);
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(WriteCompositeRequest request) {
        this.coapRequest = Request.newIPatch();
        this.coapRequest.getOptions().setContentFormat(request.getContentFormat().getCode());
        this.coapRequest.setPayload(this.encoder.encodeNodes(request.getNodes(), request.getContentFormat(), this.model));
        this.setURI(this.coapRequest, LwM2mPath.ROOTPATH);
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapWriteRequest request) {
        this.coapRequest = Request.newPut();
        this.coapRequest.setConfirmable(true);
        ContentFormat format = request.getContentFormat();
        this.coapRequest.getOptions().setContentFormat(format.getCode());
        this.coapRequest.setPayload(this.encoder.encode((LwM2mNode)request.getNode(), format, request.getPath(), this.model));
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapReadRequest request) {
        this.coapRequest = Request.newGet();
        if (request.getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getContentFormat().getCode());
        }
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapDiscoverRequest request) {
        this.coapRequest = Request.newGet();
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.coapRequest.getOptions().setAccept(40);
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapDeleteRequest request) {
        this.coapRequest = Request.newDelete();
        this.coapRequest.setConfirmable(true);
        this.setSecurityContext(this.coapRequest);
        this.setURI(this.coapRequest, request.getPath());
        this.applyLowerLayerConfig(this.coapRequest);
    }

    public void visit(BootstrapFinishRequest request) {
        this.coapRequest = Request.newPost();
        this.coapRequest.setConfirmable(true);
        this.setSecurityContext(this.coapRequest);
        if (this.rootPath != null) {
            for (String rootPathPart : this.rootPath.split("/")) {
                if (StringUtils.isEmpty((String)rootPathPart)) continue;
                this.coapRequest.getOptions().addUriPath(rootPathPart);
            }
        }
        this.coapRequest.getOptions().addUriPath("bs");
        this.applyLowerLayerConfig(this.coapRequest);
    }

    protected void setURI(Request coapRequest, LwM2mPath path) {
        if (this.rootPath != null) {
            for (String rootPathPart : this.rootPath.split("/")) {
                if (StringUtils.isEmpty((String)rootPathPart)) continue;
                coapRequest.getOptions().addUriPath(rootPathPart);
            }
        }
        if (path.getObjectId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getObjectId()));
        }
        if (path.getObjectInstanceId() == null) {
            if (path.getResourceId() != null) {
                coapRequest.getOptions().addUriPath("0");
            }
        } else {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getObjectInstanceId()));
        }
        if (path.getResourceId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getResourceId()));
        }
        if (path.getResourceInstanceId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getResourceInstanceId()));
        }
    }

    protected void setSecurityContext(Request coapRequest) {
        EndpointContext context = this.identityHandler.createEndpointContext(this.destination, this.allowConnectionInitiation);
        coapRequest.setDestinationContext(context);
        if (this.destination.getIdentity() instanceof OscoreIdentity) {
            coapRequest.getOptions().setOscore(Bytes.EMPTY);
        }
    }

    protected void applyLowerLayerConfig(Request coapRequest) {
        if (this.lowerLayerConfig != null) {
            this.lowerLayerConfig.apply((Object)coapRequest);
        }
    }

    public Request getRequest() {
        return this.coapRequest;
    }
}

