/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.endpoint.coaps;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.server.californium.endpoint.CaliforniumServerEndpointFactory;
import org.eclipse.leshan.server.californium.endpoint.ServerProtocolProvider;
import org.eclipse.leshan.server.californium.endpoint.coaps.CoapsServerEndpointFactory;
import org.eclipse.leshan.server.californium.endpoint.coaps.CoapsServerEndpointFactoryBuilder;

public class CoapsServerProtocolProvider
implements ServerProtocolProvider {
    protected Consumer<DtlsConnectorConfig.Builder> dtlsConnectorConfigInitializer;

    public CoapsServerProtocolProvider() {
    }

    public CoapsServerProtocolProvider(Consumer<DtlsConnectorConfig.Builder> dtlsConnectorConfigInitializer) {
        this.dtlsConnectorConfigInitializer = dtlsConnectorConfigInitializer;
    }

    @Override
    public Protocol getProtocol() {
        return CoapsServerEndpointFactory.getSupportedProtocol();
    }

    @Override
    public void applyDefaultValue(Configuration configuration) {
        CoapsServerEndpointFactory.applyDefaultValue(configuration);
    }

    @Override
    public List<Configuration.ModuleDefinitionsProvider> getModuleDefinitionsProviders() {
        return CoapsServerEndpointFactory.getModuleDefinitionsProviders();
    }

    @Override
    public CaliforniumServerEndpointFactory createDefaultEndpointFactory(URI uri) {
        return ((CoapsServerEndpointFactoryBuilder)new CoapsServerEndpointFactoryBuilder().setURI(uri)).setDtlsConnectorConfig(this.dtlsConnectorConfigInitializer).build();
    }

    @Override
    public URI getDefaultUri(Configuration configuration) {
        return EndpointUriUtil.createUri((String)this.getProtocol().getUriScheme(), (InetSocketAddress)new InetSocketAddress((Integer)configuration.get((BasicDefinition)CoapConfig.COAP_SECURE_PORT)));
    }
}

