/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.endpoint;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.leshan.core.californium.AsyncRequestObserver;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.SyncRequestObserver;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.observation.Observation;
import org.eclipse.leshan.core.observation.SingleObservation;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.californium.endpoint.ServerCoapMessageTranslator;
import org.eclipse.leshan.server.endpoint.LwM2mServerEndpoint;
import org.eclipse.leshan.server.endpoint.ServerEndpointToolbox;
import org.eclipse.leshan.server.observation.LwM2mNotificationReceiver;
import org.eclipse.leshan.server.profile.ClientProfile;
import org.eclipse.leshan.server.request.LowerLayerConfig;

public class CaliforniumServerEndpoint
implements LwM2mServerEndpoint {
    private final Protocol protocol;
    private final String description;
    private final ScheduledExecutorService executor;
    private final CoapEndpoint endpoint;
    private final ServerEndpointToolbox toolbox;
    private final ServerCoapMessageTranslator translator;
    private final LwM2mNotificationReceiver notificationReceiver;
    private final IdentityHandler identityHandler;
    private final ExceptionTranslator exceptionTranslator;
    private final ConcurrentNavigableMap<String, Request> ongoingRequests = new ConcurrentSkipListMap<String, Request>();
    private final AtomicLong idGenerator = new AtomicLong(0L);

    public CaliforniumServerEndpoint(Protocol protocol, String description, CoapEndpoint endpoint, ServerCoapMessageTranslator translator, ServerEndpointToolbox toolbox, LwM2mNotificationReceiver notificationReceiver, IdentityHandler identityHandler, ExceptionTranslator exceptionTranslator, ScheduledExecutorService executor) {
        this.protocol = protocol;
        this.description = description;
        this.translator = translator;
        this.toolbox = toolbox;
        this.endpoint = endpoint;
        this.notificationReceiver = notificationReceiver;
        this.identityHandler = identityHandler;
        this.exceptionTranslator = exceptionTranslator;
        this.executor = executor;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public URI getURI() {
        return EndpointUriUtil.createUri((String)this.protocol.getUriScheme(), (InetSocketAddress)this.endpoint.getAddress());
    }

    public String getDescription() {
        return this.description;
    }

    public CoapEndpoint getCoapEndpoint() {
        return this.endpoint;
    }

    public <T extends LwM2mResponse> T send(final ClientProfile destination, final DownlinkRequest<T> lwm2mRequest, LowerLayerConfig lowerLayerConfig, long timeoutInMs) throws InterruptedException {
        final Request coapRequest = this.translator.createCoapRequest(destination, lwm2mRequest, this.toolbox, this.identityHandler);
        if (lowerLayerConfig != null) {
            lowerLayerConfig.apply((Object)coapRequest);
        }
        SyncRequestObserver syncMessageObserver = new SyncRequestObserver<T>(coapRequest, timeoutInMs, this.exceptionTranslator){

            public T buildResponse(Response coapResponse) {
                Object lwM2mResponse = CaliforniumServerEndpoint.this.translator.createLwM2mResponse(destination, lwm2mRequest, coapRequest, coapResponse, CaliforniumServerEndpoint.this.toolbox);
                if (lwM2mResponse != null && lwM2mResponse.isSuccess()) {
                    SingleObservation observation = null;
                    if (lwM2mResponse instanceof ObserveResponse) {
                        observation = ((ObserveResponse)lwM2mResponse).getObservation();
                    } else if (lwM2mResponse instanceof ObserveCompositeResponse) {
                        observation = ((ObserveCompositeResponse)lwM2mResponse).getObservation();
                    }
                    if (observation != null) {
                        CaliforniumServerEndpoint.this.notificationReceiver.newObservation((Observation)observation, destination.getRegistration());
                    }
                }
                return lwM2mResponse;
            }
        };
        coapRequest.addMessageObserver((MessageObserver)syncMessageObserver);
        this.addOngoingRequest(destination.getRegistrationId(), coapRequest);
        this.endpoint.sendRequest(coapRequest);
        return (T)syncMessageObserver.waitForResponse();
    }

    public <T extends LwM2mResponse> void send(final ClientProfile destination, final DownlinkRequest<T> lwm2mRequest, ResponseCallback<T> responseCallback, ErrorCallback errorCallback, LowerLayerConfig lowerLayerConfig, long timeoutInMs) {
        Validate.notNull(responseCallback);
        Validate.notNull((Object)errorCallback);
        final Request coapRequest = this.translator.createCoapRequest(destination, lwm2mRequest, this.toolbox, this.identityHandler);
        if (lowerLayerConfig != null) {
            lowerLayerConfig.apply((Object)coapRequest);
        }
        AsyncRequestObserver obs = new AsyncRequestObserver<T>(coapRequest, responseCallback, errorCallback, timeoutInMs, this.executor, this.exceptionTranslator){

            public T buildResponse(Response coapResponse) {
                Object lwM2mResponse = CaliforniumServerEndpoint.this.translator.createLwM2mResponse(destination, lwm2mRequest, coapRequest, coapResponse, CaliforniumServerEndpoint.this.toolbox);
                if (lwM2mResponse != null && lwM2mResponse.isSuccess()) {
                    SingleObservation observation = null;
                    if (lwM2mResponse instanceof ObserveResponse) {
                        observation = ((ObserveResponse)lwM2mResponse).getObservation();
                    } else if (lwM2mResponse instanceof ObserveCompositeResponse) {
                        observation = ((ObserveCompositeResponse)lwM2mResponse).getObservation();
                    }
                    if (observation != null) {
                        CaliforniumServerEndpoint.this.notificationReceiver.newObservation((Observation)observation, destination.getRegistration());
                    }
                }
                return lwM2mResponse;
            }
        };
        coapRequest.addMessageObserver((MessageObserver)obs);
        this.addOngoingRequest(destination.getRegistrationId(), coapRequest);
        this.endpoint.sendRequest(coapRequest);
    }

    public void cancelObservation(Observation observation) {
        this.endpoint.cancelObservation(new Token(observation.getId().getBytes()));
    }

    public void cancelRequests(String sessionID) {
        Validate.notNull((Object)sessionID);
        SortedMap requests = this.ongoingRequests.subMap((Object)CaliforniumServerEndpoint.getFloorKey(sessionID), (Object)CaliforniumServerEndpoint.getCeilingKey(sessionID));
        for (Request coapRequest : requests.values()) {
            coapRequest.cancel();
        }
        requests.clear();
    }

    private static String getFloorKey(String sessionID) {
        return sessionID + '#';
    }

    private static String getCeilingKey(String sessionID) {
        return sessionID + "#A";
    }

    private static String getKey(String sessionID, long requestId) {
        return sessionID + '#' + requestId;
    }

    private void addOngoingRequest(String sessionID, Request coapRequest) {
        if (sessionID != null) {
            CleanerMessageObserver observer = new CleanerMessageObserver(sessionID, coapRequest);
            coapRequest.addMessageObserver((MessageObserver)observer);
            this.ongoingRequests.put(observer.getRequestKey(), coapRequest);
        }
    }

    private void removeOngoingRequest(String key, Request coapRequest) {
        Validate.notNull((Object)key);
        this.ongoingRequests.remove(key, coapRequest);
    }

    private class CleanerMessageObserver
    extends MessageObserverAdapter {
        private final String requestKey;
        private final Request coapRequest;

        public CleanerMessageObserver(String sessionID, Request coapRequest) {
            this.requestKey = CaliforniumServerEndpoint.getKey(sessionID, CaliforniumServerEndpoint.this.idGenerator.incrementAndGet());
            this.coapRequest = coapRequest;
        }

        public String getRequestKey() {
            return this.requestKey;
        }

        public void onRetransmission() {
        }

        public void onResponse(Response response) {
            CaliforniumServerEndpoint.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }

        public void onAcknowledgement() {
        }

        protected void failed() {
            CaliforniumServerEndpoint.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }

        public void onCancel() {
            CaliforniumServerEndpoint.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }
    }
}

