/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.endpoint;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;

public abstract class AbstractEndpointFactoryBuilder<SELF extends AbstractEndpointFactoryBuilder<SELF, TTarget>, TTarget> {
    protected URI uri;
    protected String loggingTagPrefix;
    protected Configuration configuration;
    protected Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer;

    private SELF self() {
        return (SELF)this;
    }

    protected abstract Protocol getSupportedProtocol();

    protected abstract void applyDefaultValue(Configuration var1);

    protected abstract List<Configuration.ModuleDefinitionsProvider> getModuleDefinitionsProviders();

    public abstract TTarget build();

    public SELF setURI(URI uri) {
        EndpointUriUtil.validateURI((URI)uri);
        this.uri = uri;
        return this.self();
    }

    public SELF setURI(int port) {
        return this.setURI(new InetSocketAddress(port));
    }

    public SELF setURI(InetSocketAddress addr) {
        this.uri = EndpointUriUtil.createUri((String)this.getSupportedProtocol().getUriScheme(), (InetSocketAddress)addr);
        return this.self();
    }

    public SELF setURI(String uriAsString) {
        URI uri = EndpointUriUtil.createUri((String)uriAsString);
        EndpointUriUtil.validateURI((URI)uri);
        if (!this.getSupportedProtocol().getUriScheme().equals(uri.getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid URI[%s]: Protocol Scheme MUST NOT be [%s]", uri, this.getSupportedProtocol().getUriScheme()));
        }
        return this.self();
    }

    public SELF setLoggingTagPrefix(String loggingTagPrefix) {
        this.loggingTagPrefix = loggingTagPrefix;
        return this.self();
    }

    public SELF setConfiguration(Consumer<Configuration> configurationInitializer) {
        List<Configuration.ModuleDefinitionsProvider> moduleDefinitions = this.getModuleDefinitionsProviders();
        Configuration configuration = new Configuration(moduleDefinitions.toArray(new Configuration.ModuleDefinitionsProvider[moduleDefinitions.size()]));
        this.applyDefaultValue(configuration);
        configurationInitializer.accept(configuration);
        this.configuration = configuration;
        return this.self();
    }

    public SELF setCoapEndpointConfig(Consumer<CoapEndpoint.Builder> coapEndpointConfigInitializer) {
        this.coapEndpointConfigInitializer = coapEndpointConfigInitializer;
        return this.self();
    }
}

