/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap.request;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.link.LinkParseException;
import org.eclipse.leshan.core.link.lwm2m.LwM2mLink;
import org.eclipse.leshan.core.link.lwm2m.LwM2mLinkParser;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelCompositeObservationRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.LwM2mRequest;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.request.exception.InvalidResponseException;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.BootstrapFinishResponse;
import org.eclipse.leshan.core.response.BootstrapReadResponse;
import org.eclipse.leshan.core.response.BootstrapWriteResponse;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.util.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LwM2mResponseBuilder<T extends LwM2mResponse>
implements DownlinkRequestVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(LwM2mResponseBuilder.class);
    private LwM2mResponse lwM2mresponse;
    private final Response coapResponse;
    private final String clientEndpoint;
    private final LwM2mModel model;
    private final LwM2mDecoder decoder;
    private final LwM2mLinkParser linkParser;

    public LwM2mResponseBuilder(Response coapResponse, String clientEndpoint, LwM2mModel model, LwM2mDecoder decoder, LwM2mLinkParser linkParser) {
        this.coapResponse = coapResponse;
        this.clientEndpoint = clientEndpoint;
        this.model = model;
        this.decoder = decoder;
        this.linkParser = linkParser;
    }

    public void visit(ReadRequest request) {
    }

    public void visit(DiscoverRequest request) {
    }

    public void visit(WriteRequest request) {
    }

    public void visit(WriteAttributesRequest request) {
    }

    public void visit(ExecuteRequest request) {
    }

    public void visit(CreateRequest request) {
    }

    public void visit(DeleteRequest request) {
    }

    public void visit(ObserveRequest request) {
    }

    public void visit(CancelObservationRequest request) {
    }

    public void visit(ReadCompositeRequest request) {
    }

    public void visit(ObserveCompositeRequest request) {
    }

    public void visit(CancelCompositeObservationRequest request) {
    }

    public void visit(WriteCompositeRequest request) {
    }

    public void visit(BootstrapDiscoverRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapDiscoverResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mLink[] links;
            if (40 != this.coapResponse.getOptions().getContentFormat()) {
                throw new InvalidResponseException("Client [%s] returned unexpected content format [%s] for [%s]", new Object[]{this.clientEndpoint, this.coapResponse.getOptions().getContentFormat(), request});
            }
            try {
                links = this.linkParser.parseLwM2mLinkFromCoreLinkFormat(this.coapResponse.getPayload(), null);
            }
            catch (LinkParseException e) {
                throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, this.clientEndpoint});
            }
            this.lwM2mresponse = new BootstrapDiscoverResponse(ResponseCode.CONTENT, links, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapWriteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapWriteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new BootstrapWriteResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapReadRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapReadResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), null, this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeContent()) {
            LwM2mNode content = this.decodeCoapResponse(request.getPath(), this.coapResponse, (LwM2mRequest<?>)request, this.clientEndpoint);
            this.lwM2mresponse = new BootstrapReadResponse(ResponseCode.CONTENT, content, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapDeleteRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapDeleteResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.coapResponse.getCode() == CoAP.ResponseCode.DELETED) {
            this.lwM2mresponse = new BootstrapDeleteResponse(ResponseCode.DELETED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    public void visit(BootstrapFinishRequest request) {
        if (this.coapResponse.isError()) {
            this.lwM2mresponse = new BootstrapFinishResponse(ResponseCodeUtil.toLwM2mResponseCode((CoAP.ResponseCode)this.coapResponse.getCode()), this.coapResponse.getPayloadString(), (Object)this.coapResponse);
        } else if (this.isResponseCodeChanged()) {
            this.lwM2mresponse = new BootstrapFinishResponse(ResponseCode.CHANGED, null, (Object)this.coapResponse);
        } else {
            this.handleUnexpectedResponseCode(this.clientEndpoint, (LwM2mRequest<?>)request, this.coapResponse);
        }
    }

    private boolean isResponseCodeContent() {
        return this.coapResponse.getCode() == CoAP.ResponseCode.CONTENT;
    }

    private boolean isResponseCodeChanged() {
        return this.coapResponse.getCode() == CoAP.ResponseCode.CHANGED;
    }

    private LwM2mNode decodeCoapResponse(LwM2mPath path, Response coapResponse, LwM2mRequest<?> request, String endpoint) {
        ContentFormat contentFormat = null;
        if (coapResponse.getOptions().hasContentFormat()) {
            contentFormat = ContentFormat.fromCode((int)coapResponse.getOptions().getContentFormat());
        }
        try {
            return this.decoder.decode(coapResponse.getPayload(), contentFormat, path, this.model);
        }
        catch (CodecException e) {
            if (LOG.isDebugEnabled()) {
                byte[] payload = coapResponse.getPayload() == null ? new byte[]{} : coapResponse.getPayload();
                LOG.debug(String.format("Unable to decode response payload of request [%s] from client [%s] [payload:%s]", request, endpoint, Hex.encodeHexString((byte[])payload)));
            }
            throw new InvalidResponseException((Throwable)e, "Unable to decode response payload of request [%s] from client [%s]", new Object[]{request, endpoint});
        }
    }

    public T getResponse() {
        return (T)this.lwM2mresponse;
    }

    private void handleUnexpectedResponseCode(String clientEndpoint, LwM2mRequest<?> request, Response coapResponse) {
        throw new InvalidResponseException("Client [%s] returned unexpected response code [%s] for [%s]", new Object[]{clientEndpoint, coapResponse.getCode(), request});
    }
}

