/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap.request;

import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapFinishRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.CancelCompositeObservationRequest;
import org.eclipse.leshan.core.request.CancelObservationRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.request.WriteRequest;

public class CoapRequestBuilder
implements DownlinkRequestVisitor {
    private Request coapRequest;
    private final LwM2mPeer destination;
    private final LwM2mModel model;
    private final LwM2mEncoder encoder;
    private final IdentityHandler identityHandler;

    public CoapRequestBuilder(LwM2mPeer destination, LwM2mModel model, LwM2mEncoder encoder, IdentityHandler identityHandler) {
        this.destination = destination;
        this.model = model;
        this.encoder = encoder;
        this.identityHandler = identityHandler;
    }

    public void visit(ReadRequest request) {
    }

    public void visit(DiscoverRequest request) {
    }

    public void visit(WriteRequest request) {
    }

    public void visit(WriteAttributesRequest request) {
    }

    public void visit(ExecuteRequest request) {
    }

    public void visit(CreateRequest request) {
    }

    public void visit(DeleteRequest request) {
    }

    public void visit(ObserveRequest request) {
    }

    public void visit(CancelObservationRequest request) {
    }

    public void visit(ReadCompositeRequest request) {
    }

    public void visit(ObserveCompositeRequest request) {
    }

    public void visit(CancelCompositeObservationRequest request) {
    }

    public void visit(WriteCompositeRequest request) {
    }

    public void visit(BootstrapWriteRequest request) {
        this.coapRequest = Request.newPut();
        this.coapRequest.setConfirmable(true);
        ContentFormat format = request.getContentFormat();
        this.coapRequest.getOptions().setContentFormat(format.getCode());
        this.coapRequest.setPayload(this.encoder.encode((LwM2mNode)request.getNode(), format, request.getPath(), this.model));
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
    }

    public void visit(BootstrapReadRequest request) {
        this.coapRequest = Request.newGet();
        if (request.getContentFormat() != null) {
            this.coapRequest.getOptions().setAccept(request.getContentFormat().getCode());
        }
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
    }

    public void visit(BootstrapDiscoverRequest request) {
        this.coapRequest = Request.newGet();
        this.setURI(this.coapRequest, request.getPath());
        this.setSecurityContext(this.coapRequest);
        this.coapRequest.getOptions().setAccept(40);
    }

    public void visit(BootstrapDeleteRequest request) {
        this.coapRequest = Request.newDelete();
        this.coapRequest.setConfirmable(true);
        this.setSecurityContext(this.coapRequest);
        this.setURI(this.coapRequest, request.getPath());
    }

    public void visit(BootstrapFinishRequest request) {
        this.coapRequest = Request.newPost();
        this.coapRequest.setConfirmable(true);
        this.setSecurityContext(this.coapRequest);
        this.coapRequest.getOptions().addUriPath("bs");
    }

    protected void setURI(Request coapRequest, LwM2mPath path) {
        if (path.getObjectId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getObjectId()));
        }
        if (path.getObjectInstanceId() == null) {
            if (path.getResourceId() != null) {
                coapRequest.getOptions().addUriPath("0");
            }
        } else {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getObjectInstanceId()));
        }
        if (path.getResourceId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getResourceId()));
        }
        if (path.getResourceInstanceId() != null) {
            coapRequest.getOptions().addUriPath(Integer.toString(path.getResourceInstanceId()));
        }
    }

    protected void setSecurityContext(Request coapRequest) {
        if (this.identityHandler != null) {
            EndpointContext context = this.identityHandler.createEndpointContext(this.destination, false);
            coapRequest.setDestinationContext(context);
        }
        if (this.destination.getIdentity() instanceof OscoreIdentity) {
            coapRequest.getOptions().setOscore(Bytes.EMPTY);
        }
    }

    public Request getRequest() {
        return this.coapRequest;
    }
}

