/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap.endpoint.coap;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.CoapStackFactory;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.oscore.OSCoreCoapStackFactory;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSCoreEndpointContextInfo;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.californium.oscore.cf.InMemoryOscoreContextDB;
import org.eclipse.leshan.core.californium.oscore.cf.OscoreStore;
import org.eclipse.leshan.core.peer.IpPeer;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.LwM2mPeer;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.core.util.Hex;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionListener;
import org.eclipse.leshan.server.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.californium.bootstrap.BootstrapOscoreContextCleaner;
import org.eclipse.leshan.server.californium.bootstrap.LwM2mBootstrapOscoreStore;
import org.eclipse.leshan.server.californium.bootstrap.OscoreBootstrapListener;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.coap.CoapBootstrapServerEndpointFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapOscoreBootstrapServerEndpointFactory
extends CoapBootstrapServerEndpointFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoapOscoreBootstrapServerEndpointFactory.class);

    public CoapOscoreBootstrapServerEndpointFactory(URI uri) {
        super(uri);
    }

    @Override
    public String getEndpointDescription() {
        return super.getEndpointDescription() + " with very experimental support of OSCORE";
    }

    @Override
    protected CoapEndpoint.Builder createEndpointBuilder(InetSocketAddress address, Configuration coapConfig, LeshanBootstrapServer server) {
        CoapEndpoint.Builder builder = super.createEndpointBuilder(address, coapConfig, server);
        if (server.getSecurityStore() != null) {
            InMemoryOscoreContextDB oscoreCtxDB = null;
            OscoreBootstrapListener sessionHolder = null;
            BootstrapOscoreContextCleaner oscoreContextCleaner = null;
            if (server.getSecurityStore() != null) {
                sessionHolder = new OscoreBootstrapListener();
                server.addListener((BootstrapSessionListener)sessionHolder);
                oscoreCtxDB = new InMemoryOscoreContextDB((OscoreStore)new LwM2mBootstrapOscoreStore(server.getSecurityStore(), sessionHolder));
                oscoreContextCleaner = new BootstrapOscoreContextCleaner((OSCoreCtxDB)oscoreCtxDB);
                server.addListener((BootstrapSessionListener)oscoreContextCleaner);
                builder.setCustomCoapStackArgument((Object)oscoreCtxDB).setCoapStackFactory((CoapStackFactory)new OSCoreCoapStackFactory());
                LOG.warn("Experimental OSCORE feature is enabled.");
            }
        }
        return builder;
    }

    @Override
    public IdentityHandler createIdentityHandler() {
        return new IdentityHandler(){

            public LwM2mPeer getIdentity(Message receivedMessage) {
                EndpointContext context = receivedMessage.getSourceContext();
                InetSocketAddress peerAddress = context.getPeerAddress();
                Principal senderIdentity = context.getPeerIdentity();
                if (senderIdentity == null) {
                    if (context.get(OSCoreEndpointContextInfo.OSCORE_RECIPIENT_ID) != null) {
                        String recipient = (String)context.get(OSCoreEndpointContextInfo.OSCORE_RECIPIENT_ID);
                        return new IpPeer(peerAddress, (LwM2mIdentity)new OscoreIdentity(Hex.decodeHex((char[])recipient.toCharArray())));
                    }
                    return new IpPeer(peerAddress);
                }
                return null;
            }

            public EndpointContext createEndpointContext(LwM2mPeer client, boolean allowConnectionInitiation) {
                if (client instanceof IpPeer) {
                    return new AddressEndpointContext(((IpPeer)client).getSocketAddress());
                }
                throw new IllegalStateException(String.format("Unsupported Peer : %s", client));
            }
        };
    }
}

