/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap.endpoint;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.californium.identity.IdentityHandlerProvider;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.eclipse.leshan.server.bootstrap.LeshanBootstrapServer;
import org.eclipse.leshan.server.bootstrap.endpoint.BootstrapServerEndpointToolbox;
import org.eclipse.leshan.server.bootstrap.endpoint.LwM2mBootstrapServerEndpoint;
import org.eclipse.leshan.server.bootstrap.endpoint.LwM2mBootstrapServerEndpointsProvider;
import org.eclipse.leshan.server.bootstrap.request.BootstrapUplinkRequestReceiver;
import org.eclipse.leshan.server.californium.RootResource;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.BootstrapServerCoapMessageTranslator;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.BootstrapServerProtocolProvider;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.CaliforniumBootstrapServerEndpoint;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.CaliforniumBootstrapServerEndpointFactory;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.coap.CoapBootstrapServerProtocolProvider;
import org.eclipse.leshan.server.security.ServerSecurityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumBootstrapServerEndpointsProvider
implements LwM2mBootstrapServerEndpointsProvider {
    private final Logger LOG = LoggerFactory.getLogger(CaliforniumBootstrapServerEndpointsProvider.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Leshan Async Request timeout"));
    private final Configuration serverConfig;
    private final List<CaliforniumBootstrapServerEndpointFactory> endpointsFactory;
    private final BootstrapServerCoapMessageTranslator messagetranslator = new BootstrapServerCoapMessageTranslator();
    private final List<CaliforniumBootstrapServerEndpoint> endpoints;
    private CoapServer coapServer;

    public CaliforniumBootstrapServerEndpointsProvider() {
        this(new Builder(new BootstrapServerProtocolProvider[0]).generateDefaultValue());
    }

    protected CaliforniumBootstrapServerEndpointsProvider(Builder builder) {
        this.serverConfig = builder.serverConfiguration;
        this.endpointsFactory = builder.endpointsFactory;
        this.endpoints = new ArrayList<CaliforniumBootstrapServerEndpoint>();
    }

    public CoapServer getCoapServer() {
        return this.coapServer;
    }

    public List<LwM2mBootstrapServerEndpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    public LwM2mBootstrapServerEndpoint getEndpoint(URI uri) {
        for (CaliforniumBootstrapServerEndpoint endpoint : this.endpoints) {
            if (!endpoint.getURI().equals(uri)) continue;
            return endpoint;
        }
        return null;
    }

    public void createEndpoints(BootstrapUplinkRequestReceiver requestReceiver, BootstrapServerEndpointToolbox toolbox, ServerSecurityInfo serverSecurityInfo, LeshanBootstrapServer server) {
        this.coapServer = new CoapServer(this.serverConfig, new int[0]){

            protected Resource createRoot() {
                return new RootResource();
            }
        };
        IdentityHandlerProvider identityHandlerProvider = new IdentityHandlerProvider();
        for (CaliforniumBootstrapServerEndpointFactory endpointFactory : this.endpointsFactory) {
            CoapEndpoint coapEndpoint = endpointFactory.createCoapEndpoint(this.serverConfig, serverSecurityInfo, server);
            if (coapEndpoint == null) continue;
            IdentityHandler identityHandler = endpointFactory.createIdentityHandler();
            identityHandlerProvider.addIdentityHandler((Endpoint)coapEndpoint, identityHandler);
            ExceptionTranslator exceptionTranslator = endpointFactory.createExceptionTranslator();
            CaliforniumBootstrapServerEndpoint lwm2mEndpoint = new CaliforniumBootstrapServerEndpoint(endpointFactory.getProtocol(), endpointFactory.getEndpointDescription(), coapEndpoint, this.messagetranslator, toolbox, identityHandler, exceptionTranslator, this.executor);
            this.endpoints.add(lwm2mEndpoint);
            this.coapServer.addEndpoint((Endpoint)coapEndpoint);
        }
        List<Resource> resources = this.messagetranslator.createResources(requestReceiver, toolbox, identityHandlerProvider);
        this.coapServer.add(resources.toArray(new Resource[resources.size()]));
    }

    public void start() {
        this.coapServer.start();
    }

    public void stop() {
        this.coapServer.stop();
    }

    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.LOG.warn("Destroying RequestSender was interrupted.", (Throwable)e);
        }
        this.coapServer.destroy();
    }

    public static class Builder {
        private final List<BootstrapServerProtocolProvider> protocolProviders = new ArrayList<BootstrapServerProtocolProvider>();
        private Configuration serverConfiguration;
        private final List<CaliforniumBootstrapServerEndpointFactory> endpointsFactory;

        public Builder(BootstrapServerProtocolProvider ... protocolProviders) {
            if (protocolProviders.length == 0) {
                this.protocolProviders.add(new CoapBootstrapServerProtocolProvider());
            } else {
                this.protocolProviders.addAll(Arrays.asList(protocolProviders));
            }
            this.endpointsFactory = new ArrayList<CaliforniumBootstrapServerEndpointFactory>();
        }

        public Configuration createDefaultConfiguration() {
            HashSet<Configuration.ModuleDefinitionsProvider> moduleProviders = new HashSet<Configuration.ModuleDefinitionsProvider>();
            for (BootstrapServerProtocolProvider protocolProvider : this.protocolProviders) {
                moduleProviders.addAll(protocolProvider.getModuleDefinitionsProviders());
            }
            Configuration configuration = new Configuration(moduleProviders.toArray(new Configuration.ModuleDefinitionsProvider[moduleProviders.size()]));
            for (BootstrapServerProtocolProvider protocolProvider : this.protocolProviders) {
                protocolProvider.applyDefaultValue(configuration);
            }
            return configuration;
        }

        public Builder setConfiguration(Configuration serverConfiguration) {
            this.serverConfiguration = serverConfiguration;
            return this;
        }

        public Builder setConfiguration(Consumer<Configuration> configurationSetter) {
            Configuration cfg = this.createDefaultConfiguration();
            configurationSetter.accept(cfg);
            this.serverConfiguration = cfg;
            return this;
        }

        public Builder addEndpoint(String uri) {
            return this.addEndpoint(EndpointUriUtil.createUri((String)uri));
        }

        public Builder addEndpoint(URI uri) {
            for (BootstrapServerProtocolProvider protocolProvider : this.protocolProviders) {
                if (!protocolProvider.getProtocol().getUriScheme().equals(uri.getScheme())) continue;
                this.endpointsFactory.add(protocolProvider.createDefaultEndpointFactory(uri));
            }
            return this;
        }

        public Builder addEndpoint(InetSocketAddress addr, Protocol protocol) {
            return this.addEndpoint(EndpointUriUtil.createUri((String)protocol.getUriScheme(), (InetSocketAddress)addr));
        }

        public Builder addEndpoint(CaliforniumBootstrapServerEndpointFactory endpointFactory) {
            this.endpointsFactory.add(endpointFactory);
            return this;
        }

        protected Builder generateDefaultValue() {
            if (this.serverConfiguration == null) {
                this.serverConfiguration = this.createDefaultConfiguration();
            }
            if (this.endpointsFactory.isEmpty()) {
                for (BootstrapServerProtocolProvider protocolProvider : this.protocolProviders) {
                    this.endpointsFactory.add(protocolProvider.createDefaultEndpointFactory(protocolProvider.getDefaultUri(this.serverConfiguration)));
                }
            }
            return this;
        }

        public CaliforniumBootstrapServerEndpointsProvider build() {
            this.generateDefaultValue();
            return new CaliforniumBootstrapServerEndpointsProvider(this);
        }
    }
}

