/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap.endpoint;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.leshan.core.californium.AsyncRequestObserver;
import org.eclipse.leshan.core.californium.ExceptionTranslator;
import org.eclipse.leshan.core.californium.SyncRequestObserver;
import org.eclipse.leshan.core.californium.identity.IdentityHandler;
import org.eclipse.leshan.core.endpoint.EndpointUriUtil;
import org.eclipse.leshan.core.endpoint.Protocol;
import org.eclipse.leshan.core.request.BootstrapDownlinkRequest;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.endpoint.BootstrapServerEndpointToolbox;
import org.eclipse.leshan.server.bootstrap.endpoint.LwM2mBootstrapServerEndpoint;
import org.eclipse.leshan.server.californium.bootstrap.endpoint.BootstrapServerCoapMessageTranslator;

public class CaliforniumBootstrapServerEndpoint
implements LwM2mBootstrapServerEndpoint {
    private final Protocol protocol;
    private final String description;
    private final ScheduledExecutorService executor;
    private final CoapEndpoint endpoint;
    private final BootstrapServerEndpointToolbox toolbox;
    private final BootstrapServerCoapMessageTranslator translator;
    private final IdentityHandler identityHandler;
    private final ExceptionTranslator exceptionTranslator;
    private final ConcurrentNavigableMap<String, Request> ongoingRequests = new ConcurrentSkipListMap<String, Request>();
    private final AtomicLong idGenerator = new AtomicLong(0L);

    public CaliforniumBootstrapServerEndpoint(Protocol protocol, String description, CoapEndpoint endpoint, BootstrapServerCoapMessageTranslator translator, BootstrapServerEndpointToolbox toolbox, IdentityHandler identityHandler, ExceptionTranslator exceptionTranslator, ScheduledExecutorService executor) {
        this.protocol = protocol;
        this.description = description;
        this.translator = translator;
        this.toolbox = toolbox;
        this.endpoint = endpoint;
        this.identityHandler = identityHandler;
        this.exceptionTranslator = exceptionTranslator;
        this.executor = executor;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public URI getURI() {
        return EndpointUriUtil.createUri((String)this.protocol.getUriScheme(), (InetSocketAddress)this.endpoint.getAddress());
    }

    public String getDescription() {
        return this.description;
    }

    public CoapEndpoint getCoapEndpoint() {
        return this.endpoint;
    }

    public <T extends LwM2mResponse> T send(final BootstrapSession destination, final BootstrapDownlinkRequest<T> lwm2mRequest, long timeoutInMs) throws InterruptedException {
        Request coapRequest = this.translator.createCoapRequest(destination, lwm2mRequest, this.toolbox, this.identityHandler);
        SyncRequestObserver syncMessageObserver = new SyncRequestObserver<T>(coapRequest, timeoutInMs, this.exceptionTranslator){

            public T buildResponse(Response coapResponse) {
                return CaliforniumBootstrapServerEndpoint.this.translator.createLwM2mResponse(destination, lwm2mRequest, coapResponse, CaliforniumBootstrapServerEndpoint.this.toolbox);
            }
        };
        coapRequest.addMessageObserver((MessageObserver)syncMessageObserver);
        this.addOngoingRequest(destination.getId(), coapRequest);
        this.endpoint.sendRequest(coapRequest);
        return (T)syncMessageObserver.waitForResponse();
    }

    public <T extends LwM2mResponse> void send(final BootstrapSession destination, final BootstrapDownlinkRequest<T> lwm2mRequest, ResponseCallback<T> responseCallback, ErrorCallback errorCallback, long timeoutInMs) {
        Validate.notNull(responseCallback);
        Validate.notNull((Object)errorCallback);
        Request coapRequest = this.translator.createCoapRequest(destination, lwm2mRequest, this.toolbox, this.identityHandler);
        AsyncRequestObserver obs = new AsyncRequestObserver<T>(coapRequest, responseCallback, errorCallback, timeoutInMs, this.executor, this.exceptionTranslator){

            public T buildResponse(Response coapResponse) {
                return CaliforniumBootstrapServerEndpoint.this.translator.createLwM2mResponse(destination, lwm2mRequest, coapResponse, CaliforniumBootstrapServerEndpoint.this.toolbox);
            }
        };
        coapRequest.addMessageObserver((MessageObserver)obs);
        this.addOngoingRequest(destination.getId(), coapRequest);
        this.endpoint.sendRequest(coapRequest);
    }

    public void cancelRequests(String sessionID) {
        Validate.notNull((Object)sessionID);
        SortedMap requests = this.ongoingRequests.subMap((Object)CaliforniumBootstrapServerEndpoint.getFloorKey(sessionID), (Object)CaliforniumBootstrapServerEndpoint.getCeilingKey(sessionID));
        for (Request coapRequest : requests.values()) {
            coapRequest.cancel();
        }
        requests.clear();
    }

    private static String getFloorKey(String sessionID) {
        return sessionID + '#';
    }

    private static String getCeilingKey(String sessionID) {
        return sessionID + "#A";
    }

    private static String getKey(String sessionID, long requestId) {
        return sessionID + '#' + requestId;
    }

    private void addOngoingRequest(String sessionID, Request coapRequest) {
        if (sessionID != null) {
            CleanerMessageObserver observer = new CleanerMessageObserver(sessionID, coapRequest);
            coapRequest.addMessageObserver((MessageObserver)observer);
            this.ongoingRequests.put(observer.getRequestKey(), coapRequest);
        }
    }

    private void removeOngoingRequest(String key, Request coapRequest) {
        Validate.notNull((Object)key);
        this.ongoingRequests.remove(key, coapRequest);
    }

    private class CleanerMessageObserver
    extends MessageObserverAdapter {
        private final String requestKey;
        private final Request coapRequest;

        public CleanerMessageObserver(String sessionID, Request coapRequest) {
            this.requestKey = CaliforniumBootstrapServerEndpoint.getKey(sessionID, CaliforniumBootstrapServerEndpoint.this.idGenerator.incrementAndGet());
            this.coapRequest = coapRequest;
        }

        public String getRequestKey() {
            return this.requestKey;
        }

        public void onRetransmission() {
        }

        public void onResponse(Response response) {
            CaliforniumBootstrapServerEndpoint.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }

        public void onAcknowledgement() {
        }

        protected void failed() {
            CaliforniumBootstrapServerEndpoint.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }

        public void onCancel() {
            CaliforniumBootstrapServerEndpoint.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }
    }
}

