/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.bootstrap;

import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.leshan.core.peer.LwM2mIdentity;
import org.eclipse.leshan.core.peer.OscoreIdentity;
import org.eclipse.leshan.server.bootstrap.BootstrapFailureCause;
import org.eclipse.leshan.server.bootstrap.BootstrapSession;
import org.eclipse.leshan.server.bootstrap.BootstrapSessionAdapter;

public class BootstrapOscoreContextCleaner
extends BootstrapSessionAdapter {
    private final OSCoreCtxDB oscoreCtxDB;

    public BootstrapOscoreContextCleaner(OSCoreCtxDB oscoreCtxDB) {
        this.oscoreCtxDB = oscoreCtxDB;
    }

    private void removeContext(byte[] rid) {
        OSCoreCtx context = this.oscoreCtxDB.getContext(rid);
        if (context != null) {
            this.oscoreCtxDB.removeContext(context);
        }
    }

    public void end(BootstrapSession session) {
        LwM2mIdentity clientIdentity = session.getClientTransportData().getIdentity();
        if (clientIdentity instanceof OscoreIdentity) {
            this.removeContext(((OscoreIdentity)clientIdentity).getRecipientId());
        }
    }

    public void failed(BootstrapSession session, BootstrapFailureCause cause) {
        LwM2mIdentity clientIdentity = session.getClientTransportData().getIdentity();
        if (clientIdentity instanceof OscoreIdentity) {
            this.removeContext(((OscoreIdentity)clientIdentity).getRecipientId());
        }
    }
}

