/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.object;

import java.util.Collection;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.californium.object.ResourceObserveFilter;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.resource.listener.ObjectListener;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.attributes.AttributeSet;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.link.LinkSerializer;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.StaticModel;
import org.eclipse.leshan.core.node.LwM2mNode;
import org.eclipse.leshan.core.node.LwM2mObject;
import org.eclipse.leshan.core.node.LwM2mObjectInstance;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.LwM2mResource;
import org.eclipse.leshan.core.node.codec.CodecException;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.BootstrapReadRequest;
import org.eclipse.leshan.core.request.BootstrapWriteRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.CreateRequest;
import org.eclipse.leshan.core.request.DeleteRequest;
import org.eclipse.leshan.core.request.DiscoverRequest;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.ExecuteRequest;
import org.eclipse.leshan.core.request.ObserveRequest;
import org.eclipse.leshan.core.request.ReadRequest;
import org.eclipse.leshan.core.request.WriteAttributesRequest;
import org.eclipse.leshan.core.request.WriteRequest;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.BootstrapReadResponse;
import org.eclipse.leshan.core.response.BootstrapWriteResponse;
import org.eclipse.leshan.core.response.CreateResponse;
import org.eclipse.leshan.core.response.DeleteResponse;
import org.eclipse.leshan.core.response.DiscoverResponse;
import org.eclipse.leshan.core.response.ExecuteResponse;
import org.eclipse.leshan.core.response.ObserveResponse;
import org.eclipse.leshan.core.response.ReadResponse;
import org.eclipse.leshan.core.response.WriteAttributesResponse;
import org.eclipse.leshan.core.response.WriteResponse;

public class ObjectResource
extends LwM2mClientCoapResource
implements ObjectListener {
    protected final LwM2mObjectEnabler nodeEnabler;
    protected final LwM2mEncoder encoder;
    protected final LwM2mDecoder decoder;
    protected final LinkSerializer linkSerializer;

    public ObjectResource(LwM2mObjectEnabler nodeEnabler, RegistrationEngine registrationEngine, CaliforniumEndpointsManager endpointsManager, LwM2mEncoder encoder, LwM2mDecoder decoder, LinkSerializer linkSerializer) {
        super(Integer.toString(nodeEnabler.getId()), registrationEngine, endpointsManager);
        this.nodeEnabler = nodeEnabler;
        this.linkSerializer = linkSerializer;
        this.nodeEnabler.addListener((ObjectListener)this);
        this.encoder = encoder;
        this.decoder = decoder;
        this.setObservable(true);
    }

    public void handleGET(CoapExchange exchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        String URI2 = exchange.getRequestOptions().getUriPathString();
        Request coapRequest = exchange.advanced().getRequest();
        if (exchange.getRequestOptions().getAccept() == 40) {
            if (identity.isLwm2mBootstrapServer()) {
                BootstrapDiscoverResponse response = this.nodeEnabler.discover(identity, new BootstrapDiscoverRequest(URI2, (Object)coapRequest));
                if (response.getCode().isError()) {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.linkSerializer.serialize(response.getObjectLinks()), 40);
                }
                return;
            }
            DiscoverResponse response = this.nodeEnabler.discover(identity, new DiscoverRequest(URI2, (Object)coapRequest));
            if (response.getCode().isError()) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.linkSerializer.serialize(response.getObjectLinks()), 40);
            }
            return;
        }
        ContentFormat requestedContentFormat = null;
        if (exchange.getRequestOptions().hasAccept() && !this.encoder.isSupported(requestedContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getAccept()))) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        if (exchange.getRequestOptions().hasObserve()) {
            ObserveRequest observeRequest = new ObserveRequest(requestedContentFormat, URI2, (Object)coapRequest);
            ObserveResponse response = this.nodeEnabler.observe(identity, observeRequest);
            if (response.getCode() == ResponseCode.CONTENT) {
                LwM2mPath path = new LwM2mPath(URI2);
                LwM2mNode content = response.getContent();
                StaticModel model = new StaticModel(new ObjectModel[]{this.nodeEnabler.getObjectModel()});
                ContentFormat format = this.getContentFormat((DownlinkRequest<?>)observeRequest, requestedContentFormat);
                exchange.respond(CoAP.ResponseCode.CONTENT, this.encoder.encode(content, format, path, (LwM2mModel)model), format.getCode());
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            return;
        }
        if (identity.isLwm2mBootstrapServer()) {
            BootstrapReadRequest readRequest = new BootstrapReadRequest(requestedContentFormat, URI2, (Object)coapRequest);
            BootstrapReadResponse response = this.nodeEnabler.read(identity, readRequest);
            if (response.getCode() == ResponseCode.CONTENT) {
                LwM2mPath path = new LwM2mPath(URI2);
                LwM2mNode content = response.getContent();
                StaticModel model = new StaticModel(new ObjectModel[]{this.nodeEnabler.getObjectModel()});
                ContentFormat format = this.getContentFormat((DownlinkRequest<?>)readRequest, requestedContentFormat);
                exchange.respond(CoAP.ResponseCode.CONTENT, this.encoder.encode(content, format, path, (LwM2mModel)model), format.getCode());
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            return;
        }
        ReadRequest readRequest = new ReadRequest(requestedContentFormat, URI2, (Object)coapRequest);
        ReadResponse response = this.nodeEnabler.read(identity, readRequest);
        if (response.getCode() == ResponseCode.CONTENT) {
            LwM2mPath path = new LwM2mPath(URI2);
            LwM2mNode content = response.getContent();
            StaticModel model = new StaticModel(new ObjectModel[]{this.nodeEnabler.getObjectModel()});
            ContentFormat format = this.getContentFormat((DownlinkRequest<?>)readRequest, requestedContentFormat);
            exchange.respond(CoAP.ResponseCode.CONTENT, this.encoder.encode(content, format, path, (LwM2mModel)model), format.getCode());
            return;
        }
        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
    }

    protected ContentFormat getContentFormat(DownlinkRequest<?> request, ContentFormat requestedContentFormat) {
        if (requestedContentFormat != null) {
            return requestedContentFormat;
        }
        ContentFormat format = this.nodeEnabler.getDefaultEncodingFormat(request);
        return format == null ? ContentFormat.DEFAULT : format;
    }

    public void handlePUT(CoapExchange coapExchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(coapExchange);
        if (identity == null) {
            return;
        }
        String URI2 = coapExchange.getRequestOptions().getUriPathString();
        Request coapRequest = coapExchange.advanced().getRequest();
        AttributeSet attributes = null;
        if (coapRequest.getOptions().getURIQueryCount() != 0) {
            List uriQueries = coapRequest.getOptions().getUriQuery();
            attributes = AttributeSet.parse((Collection)uriQueries);
        }
        if (attributes != null) {
            WriteAttributesResponse response = this.nodeEnabler.writeAttributes(identity, new WriteAttributesRequest(URI2, attributes, (Object)coapRequest));
            if (response.getCode().isError()) {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
            return;
        }
        LwM2mPath path = new LwM2mPath(URI2);
        if (!coapExchange.getRequestOptions().hasContentFormat()) {
            this.handleInvalidRequest(coapExchange, "Content Format is mandatory");
            return;
        }
        ContentFormat contentFormat = ContentFormat.fromCode((int)coapExchange.getRequestOptions().getContentFormat());
        if (!this.decoder.isSupported(contentFormat)) {
            coapExchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);
            return;
        }
        try {
            StaticModel model = new StaticModel(new ObjectModel[]{this.nodeEnabler.getObjectModel()});
            LwM2mNode lwM2mNode = this.decoder.decode(coapExchange.getRequestPayload(), contentFormat, path, (LwM2mModel)model);
            if (identity.isLwm2mBootstrapServer()) {
                BootstrapWriteResponse response = this.nodeEnabler.write(identity, new BootstrapWriteRequest(path, lwM2mNode, contentFormat, (Object)coapRequest));
                if (response.getCode().isError()) {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            } else {
                WriteResponse response = this.nodeEnabler.write(identity, new WriteRequest(WriteRequest.Mode.REPLACE, contentFormat, URI2, lwM2mNode, (Object)coapRequest));
                if (response.getCode().isError()) {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            }
            return;
        }
        catch (CodecException e) {
            this.handleInvalidRequest(coapExchange.advanced(), "Unable to decode payload on WRITE", e);
            return;
        }
    }

    public void handlePOST(CoapExchange exchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        String URI2 = exchange.getRequestOptions().getUriPathString();
        Request coapRequest = exchange.advanced().getRequest();
        LwM2mPath path = new LwM2mPath(URI2);
        if (path.isResource() && (!exchange.getRequestOptions().hasContentFormat() || ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat()) == ContentFormat.TEXT)) {
            byte[] payload = exchange.getRequestPayload();
            ExecuteResponse response = this.nodeEnabler.execute(identity, new ExecuteRequest(URI2, payload != null ? new String(payload) : null, (Object)coapRequest));
            if (response.getCode().isError()) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
            return;
        }
        if (!exchange.getRequestOptions().hasContentFormat()) {
            this.handleInvalidRequest(exchange, "Content Format is mandatory");
            return;
        }
        ContentFormat contentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        if (!this.decoder.isSupported(contentFormat)) {
            exchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);
            return;
        }
        StaticModel model = new StaticModel(new ObjectModel[]{this.nodeEnabler.getObjectModel()});
        if (path.isResource()) {
            try {
                LwM2mNode lwM2mNode = this.decoder.decode(exchange.getRequestPayload(), contentFormat, path, (LwM2mModel)model);
                WriteResponse response = this.nodeEnabler.write(identity, new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, URI2, lwM2mNode, (Object)coapRequest));
                if (response.getCode().isError()) {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            }
            catch (CodecException e) {
                this.handleInvalidRequest(exchange.advanced(), "Unable to decode payload on WRITE", e);
            }
            return;
        }
        if (path.isObjectInstance()) {
            try {
                LwM2mNode lwM2mNode = this.decoder.decode(exchange.getRequestPayload(), contentFormat, path, (LwM2mModel)model);
                WriteResponse response = this.nodeEnabler.write(identity, new WriteRequest(WriteRequest.Mode.UPDATE, contentFormat, URI2, lwM2mNode, (Object)coapRequest));
                if (response.getCode().isError()) {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                } else {
                    exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                }
            }
            catch (CodecException e) {
                this.handleInvalidRequest(exchange.advanced(), "Unable to decode payload on WRITE", e);
            }
            return;
        }
        try {
            LwM2mObject object = (LwM2mObject)this.decoder.decode(exchange.getRequestPayload(), contentFormat, new LwM2mPath(path.getObjectId().intValue()), (LwM2mModel)model, LwM2mObject.class);
            LwM2mObjectInstance newInstance = object.getInstance(-1);
            CreateRequest createRequest = object.getInstances().isEmpty() ? new CreateRequest(contentFormat, (Object)coapRequest, URI2, new LwM2mResource[0]) : (object.getInstances().size() == 1 && newInstance != null ? new CreateRequest(contentFormat, (Object)coapRequest, URI2, newInstance.getResources().values()) : new CreateRequest(contentFormat, (Object)coapRequest, URI2, object.getInstances().values().toArray(new LwM2mObjectInstance[object.getInstances().values().size()])));
            CreateResponse response = this.nodeEnabler.create(identity, createRequest);
            if (response.getCode() == ResponseCode.CREATED) {
                if (response.getLocation() != null) {
                    exchange.setLocationPath(response.getLocation());
                }
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            return;
        }
        catch (CodecException e) {
            this.handleInvalidRequest(exchange.advanced(), "Unable to decode payload on CREATE", e);
            return;
        }
    }

    public void handleDELETE(CoapExchange coapExchange) {
        String URI2 = coapExchange.getRequestOptions().getUriPathString();
        Request coapRequest = coapExchange.advanced().getRequest();
        ServerIdentity identity = this.getServerOrRejectRequest(coapExchange);
        if (identity == null) {
            return;
        }
        if (identity.isLwm2mBootstrapServer()) {
            BootstrapDeleteResponse response = this.nodeEnabler.delete(identity, new BootstrapDeleteRequest(URI2, (Object)coapRequest));
            if (response.getCode().isError()) {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
        } else {
            DeleteResponse response = this.nodeEnabler.delete(identity, new DeleteRequest(URI2, (Object)coapRequest));
            if (response.getCode().isError()) {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
            } else {
                coapExchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            }
        }
    }

    public Resource getChild(String name) {
        return this;
    }

    public void resourceChanged(LwM2mPath ... paths) {
        this.changed(new ResourceObserveFilter(paths));
    }

    public void objectInstancesAdded(LwM2mObjectEnabler object, int ... instanceIds) {
    }

    public void objectInstancesRemoved(LwM2mObjectEnabler object, int ... instanceIds) {
    }
}

