/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium.bootstrap;

import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.leshan.client.bootstrap.BaseBootstrapConsistencyChecker;
import org.eclipse.leshan.client.servers.DmServerInfo;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.SecurityMode;

public class DefaultBootstrapConsistencyChecker
extends BaseBootstrapConsistencyChecker {
    protected void checkBootstrapServerInfo(ServerInfo BootstrapServerInfo, List<String> errors) {
        this.checkCertificateIsValid(BootstrapServerInfo, errors);
    }

    protected void checkDeviceMangementServerInfo(DmServerInfo serverInfo, List<String> errors) {
        this.checkCertificateIsValid((ServerInfo)serverInfo, errors);
    }

    private void checkCertificateIsValid(ServerInfo serverInfo, List<String> errors) {
        if (serverInfo.secureMode == SecurityMode.X509 && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)((X509Certificate)serverInfo.clientCertificate), (boolean)true)) {
            errors.add(String.format("Client certificate for %s server can not be used for authenticate a client", serverInfo.bootstrap ? "bootstrap" : Long.valueOf(serverInfo.serverId)));
        }
    }
}

