/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.bootstrap.BootstrapHandler;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.californium.LwM2mClientCoapResource;
import org.eclipse.leshan.client.californium.ObserveCompositeRelationFilter;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.resource.LwM2mRootEnabler;
import org.eclipse.leshan.client.resource.listener.ObjectsListener;
import org.eclipse.leshan.client.resource.listener.ObjectsListenerAdapter;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.ObserveUtil;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.link.LinkSerializer;
import org.eclipse.leshan.core.node.LwM2mPath;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.BootstrapDeleteRequest;
import org.eclipse.leshan.core.request.BootstrapDiscoverRequest;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.ObserveCompositeRequest;
import org.eclipse.leshan.core.request.ReadCompositeRequest;
import org.eclipse.leshan.core.request.WriteCompositeRequest;
import org.eclipse.leshan.core.response.BootstrapDeleteResponse;
import org.eclipse.leshan.core.response.BootstrapDiscoverResponse;
import org.eclipse.leshan.core.response.ObserveCompositeResponse;
import org.eclipse.leshan.core.response.ReadCompositeResponse;
import org.eclipse.leshan.core.response.WriteCompositeResponse;
import org.eclipse.leshan.core.util.StringUtils;

public class RootResource
extends LwM2mClientCoapResource {
    protected CoapServer coapServer;
    protected BootstrapHandler bootstrapHandler;
    protected LwM2mRootEnabler rootEnabler;
    protected LwM2mEncoder encoder;
    protected LwM2mDecoder decoder;
    protected LinkSerializer linkSerializer;

    public RootResource(RegistrationEngine registrationEngine, CaliforniumEndpointsManager endpointsManager, BootstrapHandler bootstrapHandler, CoapServer coapServer, LwM2mRootEnabler rootEnabler, LwM2mEncoder encoder, LwM2mDecoder decoder, LinkSerializer linkSerializer) {
        super("", registrationEngine, endpointsManager);
        this.bootstrapHandler = bootstrapHandler;
        this.setVisible(false);
        this.setObservable(true);
        this.coapServer = coapServer;
        this.rootEnabler = rootEnabler;
        this.encoder = encoder;
        this.decoder = decoder;
        this.linkSerializer = linkSerializer;
        this.addListeners();
    }

    public void handleGET(CoapExchange exchange) {
        Request coapRequest;
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        String URI2 = exchange.getRequestOptions().getUriPathString();
        BootstrapDiscoverResponse response = this.bootstrapHandler.discover(identity, new BootstrapDiscoverRequest(URI2, (Object)(coapRequest = exchange.advanced().getRequest())));
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.linkSerializer.serialize(response.getObjectLinks()), 40);
        }
    }

    public void handleFETCH(CoapExchange exchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        Request coapRequest = exchange.advanced().getRequest();
        ContentFormat responseContentFormat = ContentFormat.SENML_CBOR;
        if (exchange.getRequestOptions().hasAccept() && !this.encoder.isSupported(responseContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getAccept()))) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        if (!exchange.getRequestOptions().hasContentFormat()) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
            return;
        }
        ContentFormat requestContentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        List paths = this.decoder.decodePaths(coapRequest.getPayload(), requestContentFormat);
        if (exchange.getRequestOptions().hasObserve()) {
            ObserveCompositeRequest observeRequest = new ObserveCompositeRequest(requestContentFormat, responseContentFormat, paths, (Object)coapRequest);
            ObserveCompositeResponse response = this.rootEnabler.observe(identity, observeRequest);
            this.updateUserContextWithPaths(coapRequest, paths);
            if (response.getCode().isError()) {
                exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
                return;
            }
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.encoder.encodeNodes(response.getContent(), responseContentFormat, this.rootEnabler.getModel()), responseContentFormat.getCode());
            return;
        }
        ReadCompositeResponse response = this.rootEnabler.read(identity, new ReadCompositeRequest(paths, requestContentFormat, responseContentFormat, (Object)coapRequest));
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), this.encoder.encodeNodes(response.getContent(), responseContentFormat, this.rootEnabler.getModel()), responseContentFormat.getCode());
        }
    }

    private void updateUserContextWithPaths(Request coapRequest, List<LwM2mPath> paths) {
        HashMap userContext = new HashMap();
        if (coapRequest.getUserContext() != null) {
            userContext.putAll(coapRequest.getUserContext());
        }
        ObserveUtil.addPathsIntoContext(userContext, paths);
        coapRequest.setUserContext(userContext);
    }

    public void handleIPATCH(CoapExchange exchange) {
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        Request coapRequest = exchange.advanced().getRequest();
        ContentFormat contentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        if (!this.decoder.isSupported(contentFormat)) {
            exchange.respond(CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT);
            return;
        }
        Map nodes = this.decoder.decodeNodes(coapRequest.getPayload(), contentFormat, null, this.rootEnabler.getModel());
        WriteCompositeResponse response = this.rootEnabler.write(identity, new WriteCompositeRequest(contentFormat, nodes, (Object)coapRequest));
        if (response.getCode().isError()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        } else {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
        }
    }

    public void handleDELETE(CoapExchange exchange) {
        String URI2 = exchange.getRequestOptions().getUriPathString();
        if (!StringUtils.isEmpty((String)URI2)) {
            exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
            return;
        }
        ServerIdentity identity = this.getServerOrRejectRequest(exchange);
        if (identity == null) {
            return;
        }
        Request coapRequest = exchange.advanced().getRequest();
        BootstrapDeleteResponse response = this.bootstrapHandler.delete(identity, new BootstrapDeleteRequest(URI2, (Object)coapRequest));
        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
    }

    private void addListeners() {
        this.rootEnabler.addListener((ObjectsListener)new ObjectsListenerAdapter(){

            public void resourceChanged(LwM2mPath ... paths) {
                RootResource.this.changed(new ObserveCompositeRelationFilter(paths));
            }
        });
    }
}

