/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.DocumentedDefinition;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.leshan.client.bootstrap.BootstrapConsistencyChecker;
import org.eclipse.leshan.client.californium.LeshanClient;
import org.eclipse.leshan.client.californium.bootstrap.DefaultBootstrapConsistencyChecker;
import org.eclipse.leshan.client.engine.DefaultRegistrationEngineFactory;
import org.eclipse.leshan.client.engine.RegistrationEngineFactory;
import org.eclipse.leshan.client.object.Device;
import org.eclipse.leshan.client.object.Security;
import org.eclipse.leshan.client.object.Server;
import org.eclipse.leshan.client.resource.LwM2mInstanceEnabler;
import org.eclipse.leshan.client.resource.LwM2mObjectEnabler;
import org.eclipse.leshan.client.resource.ObjectsInitializer;
import org.eclipse.leshan.core.californium.DefaultEndpointFactory;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.link.DefaultLinkSerializer;
import org.eclipse.leshan.core.link.LinkSerializer;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.BindingMode;
import org.eclipse.leshan.core.util.Validate;

public class LeshanClientBuilder {
    private final String endpoint;
    private InetSocketAddress localAddress;
    private List<? extends LwM2mObjectEnabler> objectEnablers;
    private Configuration coapConfig;
    private DtlsConnectorConfig.Builder dtlsConfigBuilder;
    private List<Certificate> trustStore;
    private LwM2mEncoder encoder;
    private LwM2mDecoder decoder;
    private EndpointFactory endpointFactory;
    private RegistrationEngineFactory engineFactory;
    private Map<String, String> additionalAttributes;
    private Map<String, String> bsAdditionalAttributes;
    private BootstrapConsistencyChecker bootstrapConsistencyChecker;
    private ScheduledExecutorService executor;
    private LinkSerializer linkSerializer;

    public LeshanClientBuilder(String endpoint) {
        Validate.notEmpty((String)endpoint);
        this.endpoint = endpoint;
    }

    public LeshanClientBuilder setLocalAddress(String hostname, int port) {
        this.localAddress = hostname == null ? new InetSocketAddress(port) : new InetSocketAddress(hostname, port);
        return this;
    }

    public LeshanClientBuilder setObjects(List<? extends LwM2mObjectEnabler> objectEnablers) {
        this.objectEnablers = objectEnablers;
        return this;
    }

    public LeshanClientBuilder setEncoder(LwM2mEncoder encoder) {
        this.encoder = encoder;
        return this;
    }

    public LeshanClientBuilder setDecoder(LwM2mDecoder decoder) {
        this.decoder = decoder;
        return this;
    }

    public void setLinkSerializer(LinkSerializer linkSerializer) {
        this.linkSerializer = linkSerializer;
    }

    public LeshanClientBuilder setCoapConfig(Configuration config) {
        this.coapConfig = config;
        return this;
    }

    public LeshanClientBuilder setDtlsConfig(DtlsConnectorConfig.Builder config) {
        this.dtlsConfigBuilder = config;
        return this;
    }

    public LeshanClientBuilder setTrustStore(List<Certificate> trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public LeshanClientBuilder setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public LeshanClientBuilder setRegistrationEngineFactory(RegistrationEngineFactory engineFactory) {
        this.engineFactory = engineFactory;
        return this;
    }

    public LeshanClientBuilder setAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
        return this;
    }

    public LeshanClientBuilder setBootstrapAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.bsAdditionalAttributes = additionalAttributes;
        return this;
    }

    public LeshanClientBuilder setBootstrapConsistencyChecker(BootstrapConsistencyChecker checker) {
        this.bootstrapConsistencyChecker = checker;
        return this;
    }

    public LeshanClientBuilder setSharedExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public static Configuration createDefaultCoapConfiguration() {
        Configuration networkConfig = new Configuration(new Configuration.ModuleDefinitionsProvider[]{CoapConfig.DEFINITIONS, DtlsConfig.DEFINITIONS, UdpConfig.DEFINITIONS, SystemConfig.DEFINITIONS});
        networkConfig.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.NULL);
        networkConfig.set((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS, (Object)10);
        networkConfig.set((BasicDefinition)CoapConfig.PROTOCOL_STAGE_THREAD_COUNT, (Object)1);
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_MAX_CONNECTIONS, (Object)10);
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_RECEIVER_THREAD_COUNT, (Object)1);
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_CONNECTOR_THREAD_COUNT, (Object)1);
        networkConfig.setTransient((DocumentedDefinition)DtlsConfig.DTLS_VERIFY_SERVER_CERTIFICATES_SUBJECT);
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_ROLE, null);
        return networkConfig;
    }

    public LeshanClient build() {
        DtlsConnectorConfig incompleteConfig;
        if (this.localAddress == null) {
            this.localAddress = new InetSocketAddress(0);
        }
        if (this.objectEnablers == null) {
            ObjectsInitializer initializer = new ObjectsInitializer();
            initializer.setInstancesForObject(0, new LwM2mInstanceEnabler[]{Security.noSec((String)"coap://leshan.eclipseprojects.io:5683", (int)12345)});
            initializer.setInstancesForObject(1, new LwM2mInstanceEnabler[]{new Server(12345, 300L)});
            initializer.setInstancesForObject(3, new LwM2mInstanceEnabler[]{new Device("Eclipse Leshan", "model12345", "12345", EnumSet.of(BindingMode.U))});
            this.objectEnablers = initializer.createAll();
        }
        if (this.encoder == null) {
            this.encoder = new DefaultLwM2mEncoder();
        }
        if (this.decoder == null) {
            this.decoder = new DefaultLwM2mDecoder();
        }
        if (this.linkSerializer == null) {
            this.linkSerializer = new DefaultLinkSerializer();
        }
        if (this.coapConfig == null) {
            this.coapConfig = LeshanClientBuilder.createDefaultCoapConfiguration();
        }
        if (this.engineFactory == null) {
            this.engineFactory = new DefaultRegistrationEngineFactory();
        }
        if (this.endpointFactory == null) {
            this.endpointFactory = new DefaultEndpointFactory("LWM2M Client", true){

                protected Connector createSecuredConnector(DtlsConnectorConfig dtlsConfig) {
                    DTLSConnector dtlsConnector = new DTLSConnector(dtlsConfig);
                    if (LeshanClientBuilder.this.executor != null) {
                        dtlsConnector.setExecutor((ExecutorService)LeshanClientBuilder.this.executor);
                    }
                    return dtlsConnector;
                }
            };
        }
        if (this.bootstrapConsistencyChecker == null) {
            this.bootstrapConsistencyChecker = new DefaultBootstrapConsistencyChecker();
        }
        if (this.dtlsConfigBuilder == null) {
            this.dtlsConfigBuilder = DtlsConnectorConfig.builder((Configuration)this.coapConfig);
        }
        if ((incompleteConfig = this.dtlsConfigBuilder.getIncompleteConfig()).getAddress() == null) {
            if (this.localAddress == null) {
                this.localAddress = new InetSocketAddress(0);
            }
            this.dtlsConfigBuilder.setAddress(this.localAddress);
        } else if (this.localAddress != null && !this.localAddress.equals(incompleteConfig.getAddress())) {
            throw new IllegalStateException(String.format("Configuration conflict between LeshanBuilder and DtlsConnectorConfig.Builder for address: %s != %s", this.localAddress, incompleteConfig.getAddress()));
        }
        return this.createLeshanClient(this.endpoint, this.localAddress, this.objectEnablers, this.coapConfig, this.dtlsConfigBuilder, this.trustStore, this.endpointFactory, this.engineFactory, this.bootstrapConsistencyChecker, this.additionalAttributes, this.bsAdditionalAttributes, this.encoder, this.decoder, this.executor, this.linkSerializer);
    }

    protected LeshanClient createLeshanClient(String endpoint, InetSocketAddress localAddress, List<? extends LwM2mObjectEnabler> objectEnablers, Configuration coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, List<Certificate> trustStore, EndpointFactory endpointFactory, RegistrationEngineFactory engineFactory, BootstrapConsistencyChecker checker, Map<String, String> additionalAttributes, Map<String, String> bsAdditionalAttributes, LwM2mEncoder encoder, LwM2mDecoder decoder, ScheduledExecutorService sharedExecutor, LinkSerializer linkSerializer) {
        return new LeshanClient(endpoint, localAddress, objectEnablers, coapConfig, dtlsConfigBuilder, trustStore, endpointFactory, engineFactory, checker, additionalAttributes, bsAdditionalAttributes, encoder, decoder, sharedExecutor, linkSerializer);
    }
}

