/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedSinglePskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.leshan.client.EndpointsManager;
import org.eclipse.leshan.client.californium.CaConstraintCertificateVerifier;
import org.eclipse.leshan.client.californium.DomainIssuerCertificateVerifier;
import org.eclipse.leshan.client.californium.ServiceCertificateConstraintCertificateVerifier;
import org.eclipse.leshan.client.californium.TrustAnchorAssertionCertificateVerifier;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.client.servers.ServerInfo;
import org.eclipse.leshan.core.CertificateUsage;
import org.eclipse.leshan.core.SecurityMode;
import org.eclipse.leshan.core.californium.EndpointFactory;
import org.eclipse.leshan.core.request.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaliforniumEndpointsManager
implements EndpointsManager {
    private static final Logger LOG = LoggerFactory.getLogger(CaliforniumEndpointsManager.class);
    protected boolean started = false;
    protected ServerIdentity currentServer;
    protected CoapEndpoint currentEndpoint;
    protected DtlsConnectorConfig.Builder dtlsConfigbuilder;
    protected List<Certificate> trustStore;
    protected Configuration coapConfig;
    protected InetSocketAddress localAddress;
    protected CoapServer coapServer;
    protected EndpointFactory endpointFactory;

    public CaliforniumEndpointsManager(InetSocketAddress localAddress, Configuration coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, EndpointFactory endpointFactory) {
        this(localAddress, coapConfig, dtlsConfigBuilder, null, endpointFactory);
    }

    public CaliforniumEndpointsManager(InetSocketAddress localAddress, Configuration coapConfig, DtlsConnectorConfig.Builder dtlsConfigBuilder, List<Certificate> trustStore, EndpointFactory endpointFactory) {
        this.localAddress = localAddress;
        this.coapConfig = coapConfig;
        this.dtlsConfigbuilder = dtlsConfigBuilder;
        this.trustStore = trustStore;
        this.endpointFactory = endpointFactory;
    }

    public void setCoapServer(CoapServer coapServer) {
        this.coapServer = coapServer;
    }

    public synchronized ServerIdentity createEndpoint(ServerInfo serverInfo, boolean clientInitiatedOnly) {
        Identity serverIdentity;
        if (this.currentEndpoint != null) {
            this.coapServer.getEndpoints().remove(this.currentEndpoint);
            this.currentEndpoint.destroy();
        }
        if (serverInfo.isSecure()) {
            X509Certificate certificate;
            DtlsConnectorConfig incompleteConfig = this.dtlsConfigbuilder.getIncompleteConfig();
            DtlsConnectorConfig.Builder newBuilder = DtlsConnectorConfig.builder((DtlsConnectorConfig)incompleteConfig);
            if (serverInfo.secureMode == SecurityMode.PSK) {
                AdvancedSinglePskStore staticPskStore = new AdvancedSinglePskStore(serverInfo.pskId, serverInfo.pskKey);
                newBuilder.setAdvancedPskStore((AdvancedPskStore)staticPskStore);
                serverIdentity = Identity.psk((InetSocketAddress)serverInfo.getAddress(), (String)serverInfo.pskId);
                this.filterCipherSuites(newBuilder, this.dtlsConfigbuilder.getIncompleteConfig().getSupportedCipherSuites(), true, false);
            } else if (serverInfo.secureMode == SecurityMode.RPK) {
                newBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(serverInfo.privateKey, serverInfo.publicKey));
                PublicKey expectedKey = serverInfo.serverPublicKey;
                NewAdvancedCertificateVerifier rpkVerifier = new StaticNewAdvancedCertificateVerifier.Builder().setTrustedRPKs(new RawPublicKeyIdentity[]{new RawPublicKeyIdentity(expectedKey)}).build();
                newBuilder.setAdvancedCertificateVerifier(rpkVerifier);
                serverIdentity = Identity.rpk((InetSocketAddress)serverInfo.getAddress(), (PublicKey)expectedKey);
                this.filterCipherSuites(newBuilder, this.dtlsConfigbuilder.getIncompleteConfig().getSupportedCipherSuites(), false, true);
            } else if (serverInfo.secureMode == SecurityMode.X509) {
                X509Certificate[] trustedCertificates;
                CertificateUsage certificateUsage;
                newBuilder.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(serverInfo.privateKey, new Certificate[]{serverInfo.clientCertificate}, new CertificateType[0]));
                CertificateUsage certificateUsage2 = certificateUsage = serverInfo.certificateUsage != null ? serverInfo.certificateUsage : CertificateUsage.DOMAIN_ISSUER_CERTIFICATE;
                if (certificateUsage == CertificateUsage.CA_CONSTRAINT) {
                    trustedCertificates = null;
                    ArrayList<X509Certificate> newTrustedCertificatesList = new ArrayList<X509Certificate>();
                    if (this.trustStore != null) {
                        newTrustedCertificatesList.addAll(CertPathUtil.toX509CertificatesList(this.trustStore));
                    }
                    newTrustedCertificatesList.add((X509Certificate)serverInfo.serverCertificate);
                    trustedCertificates = newTrustedCertificatesList.toArray(new X509Certificate[0]);
                    newBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new CaConstraintCertificateVerifier(serverInfo.serverCertificate, trustedCertificates));
                } else if (certificateUsage == CertificateUsage.SERVICE_CERTIFICATE_CONSTRAINT) {
                    trustedCertificates = null;
                    if (this.trustStore != null) {
                        trustedCertificates = CertPathUtil.toX509CertificatesList(this.trustStore).toArray(new X509Certificate[0]);
                    }
                    newBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new ServiceCertificateConstraintCertificateVerifier(serverInfo.serverCertificate, trustedCertificates));
                } else if (certificateUsage == CertificateUsage.TRUST_ANCHOR_ASSERTION) {
                    newBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new TrustAnchorAssertionCertificateVerifier((X509Certificate)serverInfo.serverCertificate));
                } else if (certificateUsage == CertificateUsage.DOMAIN_ISSUER_CERTIFICATE) {
                    newBuilder.setAdvancedCertificateVerifier((NewAdvancedCertificateVerifier)new DomainIssuerCertificateVerifier(serverInfo.serverCertificate));
                }
                serverIdentity = Identity.x509((InetSocketAddress)serverInfo.getAddress(), (String)"*");
                this.filterCipherSuites(newBuilder, this.dtlsConfigbuilder.getIncompleteConfig().getSupportedCipherSuites(), false, true);
            } else {
                throw new RuntimeException("Unable to create connector : unsupported security mode");
            }
            DtlsConfig.DtlsRole dtlsRole = (DtlsConfig.DtlsRole)incompleteConfig.getConfiguration().get((BasicDefinition)DtlsConfig.DTLS_ROLE);
            if (dtlsRole == null) {
                if (serverInfo.bootstrap) {
                    newBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
                } else if (clientInitiatedOnly) {
                    newBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
                } else {
                    newBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.BOTH);
                }
            }
            if (incompleteConfig.getConfiguration().get((BasicDefinition)DtlsConfig.DTLS_ROLE) == DtlsConfig.DtlsRole.BOTH && serverInfo.secureMode == SecurityMode.X509 && CertPathUtil.canBeUsedForAuthentication((X509Certificate)(certificate = (X509Certificate)serverInfo.clientCertificate), (boolean)true) && !CertPathUtil.canBeUsedForAuthentication((X509Certificate)certificate, (boolean)false)) {
                newBuilder.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
                LOG.warn("Client certificate does not allow Server Authentication usage.\nThis will prevent a LWM2M server to initiate DTLS connection to this client.\nSee : https://github.com/eclipse/leshan/wiki/Server-Failover#about-connections");
            }
            this.currentEndpoint = this.endpointFactory.createSecuredEndpoint(newBuilder.build(), this.coapConfig, null);
        } else {
            this.currentEndpoint = this.endpointFactory.createUnsecuredEndpoint(this.localAddress, this.coapConfig, null);
            serverIdentity = Identity.unsecure((InetSocketAddress)serverInfo.getAddress());
        }
        this.coapServer.addEndpoint((Endpoint)this.currentEndpoint);
        this.currentServer = serverInfo.bootstrap ? new ServerIdentity(serverIdentity, Long.valueOf(serverInfo.serverId), ServerIdentity.Role.LWM2M_BOOTSTRAP_SERVER) : new ServerIdentity(serverIdentity, Long.valueOf(serverInfo.serverId));
        if (this.started) {
            this.coapServer.start();
            try {
                this.currentEndpoint.start();
                LOG.info("New endpoint created for server {} at {}", (Object)this.currentServer.getUri(), (Object)this.currentEndpoint.getUri());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to start endpoint", e);
            }
        }
        return this.currentServer;
    }

    public synchronized Collection<ServerIdentity> createEndpoints(Collection<? extends ServerInfo> serverInfo, boolean clientInitiatedOnly) {
        if (serverInfo == null || serverInfo.isEmpty()) {
            return null;
        }
        if (serverInfo.size() > 1) {
            LOG.warn("CaliforniumEndpointsManager support only connection to 1 LWM2M server, first server will be used from the server list of {}", (Object)serverInfo.size());
        }
        ServerInfo firstServer = serverInfo.iterator().next();
        ArrayList<ServerIdentity> servers = new ArrayList<ServerIdentity>(1);
        servers.add(this.createEndpoint(firstServer, clientInitiatedOnly));
        return servers;
    }

    public long getMaxCommunicationPeriodFor(ServerIdentity server, long lifetimeInMs) {
        int floor = 30000;
        long exchange_lifetime = this.coapConfig.get(CoapConfig.EXCHANGE_LIFETIME, TimeUnit.MILLISECONDS);
        if (lifetimeInMs - exchange_lifetime >= (long)floor) {
            return lifetimeInMs - exchange_lifetime;
        }
        LOG.warn("Too small lifetime : we advice to not use a lifetime < (COAP EXCHANGE LIFETIME + 30s)");
        return lifetimeInMs * (long)(floor - 1000) / (exchange_lifetime + (long)floor) + 1000L;
    }

    public synchronized void forceReconnection(ServerIdentity server, boolean resume) {
        if (server == null || !server.equals((Object)this.currentServer)) {
            return;
        }
        Connector connector = this.currentEndpoint.getConnector();
        if (connector instanceof DTLSConnector) {
            if (resume) {
                LOG.info("Clear DTLS session for resumption for server {}", (Object)server.getUri());
                ((DTLSConnector)connector).forceResumeAllSessions();
            } else {
                LOG.info("Clear DTLS session for server {}", (Object)server.getUri());
                ((DTLSConnector)connector).clearConnectionState();
            }
        }
    }

    public synchronized Endpoint getEndpoint(ServerIdentity server) {
        if (server != null && server.equals((Object)this.currentServer) && this.currentEndpoint.isStarted()) {
            return this.currentEndpoint;
        }
        return null;
    }

    public synchronized ServerIdentity getServerIdentity(Endpoint endpoint, InetSocketAddress serverAddress) {
        if (endpoint != null && endpoint.equals(this.currentEndpoint) && this.currentEndpoint.isStarted()) {
            if (this.currentEndpoint.getConnector().getProtocol() == "UDP" && !this.currentServer.getIdentity().getPeerAddress().equals(serverAddress)) {
                return null;
            }
            return this.currentServer;
        }
        return null;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.currentEndpoint == null) {
            return;
        }
        this.coapServer.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.currentEndpoint == null) {
            return;
        }
        this.coapServer.stop();
    }

    public synchronized void destroy() {
        if (this.started) {
            this.started = false;
        }
        this.coapServer.destroy();
    }

    private void filterCipherSuites(DtlsConnectorConfig.Builder dtlsConfigurationBuilder, List<CipherSuite> ciphers, boolean psk, boolean requireServerCertificateMessage) {
        if (ciphers == null) {
            return;
        }
        ArrayList<CipherSuite> filteredCiphers = new ArrayList<CipherSuite>();
        for (CipherSuite cipher : ciphers) {
            if (psk && cipher.isPskBased()) {
                filteredCiphers.add(cipher);
                continue;
            }
            if (!requireServerCertificateMessage || !cipher.requiresServerCertificateMessage()) continue;
            filteredCiphers.add(cipher);
        }
        dtlsConfigurationBuilder.setSupportedCipherSuites(filteredCiphers);
    }
}

