/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.leshan.client.californium.BaseCertificateVerifier;
import org.eclipse.leshan.client.californium.X509Util;
import org.eclipse.leshan.core.util.Validate;

public class CaConstraintCertificateVerifier
extends BaseCertificateVerifier {
    private final Certificate caCertificate;
    private final X509Certificate[] trustedCertificates;

    public CaConstraintCertificateVerifier(Certificate caCertificate, X509Certificate[] trustedCertificates) {
        Validate.notNull((Object)caCertificate);
        Validate.notNull((Object)trustedCertificates);
        Validate.notEmpty((Object[])trustedCertificates);
        this.caCertificate = caCertificate;
        this.trustedCertificates = trustedCertificates;
    }

    @Override
    public CertPath verifyCertificate(Boolean clientUsage, CertificateMessage message, DTLSSession session) throws HandshakeException {
        CertPath certPath;
        CertPath messageChain = message.getCertificateChain();
        this.validateCertificateChainNotEmpty(messageChain, session.getPeer());
        X509Certificate receivedServerCertificate = this.validateReceivedCertificateIsSupported(messageChain, session.getPeer());
        try {
            certPath = X509Util.applyPKIXValidation(messageChain, this.trustedCertificates);
        }
        catch (GeneralSecurityException e) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            throw new HandshakeException("Certificate chain could not be validated", alert, (Throwable)e);
        }
        if (!certPath.getCertificates().contains(this.caCertificate)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
            throw new HandshakeException("Certificate chain could not be validated", alert);
        }
        this.validateSubject(session, receivedServerCertificate);
        return certPath;
    }
}

