/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.eclipse.leshan.core.util.X509CertUtil;

public abstract class BaseCertificateVerifier
implements NewAdvancedCertificateVerifier {
    private final List<CertificateType> supportedCertificateType = Arrays.asList(CertificateType.X_509);

    public List<CertificateType> getSupportedCertificateType() {
        return this.supportedCertificateType;
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    public List<X500Principal> getAcceptedIssuers() {
        return Collections.emptyList();
    }

    public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, Boolean clientUsage, boolean truncateCertificatePath, CertificateMessage message, DTLSSession session) {
        try {
            CertPath validatedCertPath = this.verifyCertificate(clientUsage, message, session);
            return new CertificateVerificationResult(cid, validatedCertPath, null);
        }
        catch (HandshakeException exception) {
            return new CertificateVerificationResult(cid, exception, null);
        }
    }

    protected abstract CertPath verifyCertificate(Boolean var1, CertificateMessage var2, DTLSSession var3) throws HandshakeException;

    protected void validateCertificateChainNotEmpty(CertPath certChain, InetSocketAddress foreignPeerAddress) throws HandshakeException {
        if (certChain.getCertificates().size() == 0) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, foreignPeerAddress);
            throw new HandshakeException("Certificate chain could not be validated : server cert chain is empty", alert);
        }
    }

    protected X509Certificate validateReceivedCertificateIsSupported(CertPath certChain, InetSocketAddress foreignPeerAddress) throws HandshakeException {
        Certificate receivedServerCertificate = certChain.getCertificates().get(0);
        if (!(receivedServerCertificate instanceof X509Certificate)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE, foreignPeerAddress);
            throw new HandshakeException("Certificate chain could not be validated - unknown certificate type", alert);
        }
        return (X509Certificate)receivedServerCertificate;
    }

    protected void validateSubject(DTLSSession session, X509Certificate receivedServerCertificate) throws HandshakeException {
        InetSocketAddress peerSocket = session.getPeer();
        if (X509CertUtil.matchSubjectDnsName((X509Certificate)receivedServerCertificate, (String)peerSocket.getHostName())) {
            return;
        }
        if (X509CertUtil.matchSubjectInetAddress((X509Certificate)receivedServerCertificate, (InetAddress)peerSocket.getAddress())) {
            return;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, session.getPeer());
        throw new HandshakeException("Certificate chain could not be validated - server identity does not match certificate", alert);
    }
}

