/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class MavenResource
extends Resource {
    private static final ResourceFactory __resourceFactory = ResourceFactory.root();
    private String _resourceString;
    private Resource _resource;

    public void copyTo(Path destination) throws IOException {
        if (this._resource == null) {
            return;
        }
        this._resource.copyTo(destination);
    }

    public boolean exists() {
        if (this._resource == null) {
            return false;
        }
        return this._resource.exists();
    }

    public Collection<Resource> getAllResources() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.getAllResources();
    }

    public String getFileName() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.getFileName();
    }

    public String getName() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.getName();
    }

    public Path getPath() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.getPath();
    }

    public URI getRealURI() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.getRealURI();
    }

    public String getResourceAsString() {
        return this._resourceString;
    }

    public void setResourceAsString(String resourceString) {
        this._resourceString = resourceString;
        this._resource = __resourceFactory.newResource(this._resourceString);
    }

    public URI getURI() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.getURI();
    }

    public boolean isAlias() {
        if (this._resource == null) {
            return false;
        }
        return this._resource.isAlias();
    }

    public boolean isContainedIn(Resource container) {
        if (this._resource == null) {
            return false;
        }
        return this._resource.isContainedIn(container);
    }

    public boolean contains(Resource other) {
        if (this._resource == null) {
            return false;
        }
        return this._resource.contains(other);
    }

    public Path getPathTo(Resource other) {
        if (this._resource == null) {
            return null;
        }
        return this._resource.getPathTo(other);
    }

    public boolean isDirectory() {
        if (this._resource == null) {
            return false;
        }
        return this._resource.isDirectory();
    }

    public boolean isReadable() {
        if (this._resource == null) {
            return false;
        }
        return this._resource.isReadable();
    }

    public Iterator<Resource> iterator() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.iterator();
    }

    public Instant lastModified() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.lastModified();
    }

    public long length() {
        if (this._resource == null) {
            return -1L;
        }
        return this._resource.length();
    }

    public List<Resource> list() {
        if (this._resource == null) {
            return null;
        }
        return this._resource.list();
    }

    public InputStream newInputStream() throws IOException {
        if (this._resource == null) {
            return null;
        }
        return this._resource.newInputStream();
    }

    public Resource resolve(String subUriPath) {
        if (this._resource == null) {
            return null;
        }
        return this._resource.resolve(subUriPath);
    }

    public String toString() {
        return "(Maven) " + this._resource.toString();
    }
}

