/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.server.config;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServletContainerInitializer.class);
    private final Configurator configurator;

    public JettyWebSocketServletContainerInitializer() {
        this(null);
    }

    public JettyWebSocketServletContainerInitializer(Configurator configurator) {
        this.configurator = configurator;
    }

    public static void configure(ServletContextHandler context, Configurator configurator) {
        if (!context.isStopped()) {
            throw new IllegalStateException("configure should be called before starting");
        }
        context.addServletContainerInitializer((ServletContainerInitializer)new JettyWebSocketServletContainerInitializer(configurator));
    }

    private static JettyWebSocketServerContainer initialize(ServletContextHandler context) {
        WebSocketComponents components = WebSocketServerComponents.ensureWebSocketComponents((Server)context.getServer(), (ContextHandler)context.getCoreContextHandler());
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialize {} {}", (Object)container, (Object)components);
        }
        return container;
    }

    public void onStartup(Set<Class<?>> c, ServletContext context) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)context, (String)"Jetty WebSocket SCI");
        JettyWebSocketServerContainer container = JettyWebSocketServletContainerInitializer.initialize(contextHandler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("onStartup {}", (Object)container);
        }
        if (this.configurator != null) {
            this.configurator.accept(context, container);
        }
    }

    public static interface Configurator {
        public void accept(ServletContext var1, JettyWebSocketServerContainer var2);
    }
}

