/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class DuplicateInstruction
implements Instruction {
    private final int _index;

    public DuplicateInstruction(int index) {
        this._index = index;
    }

    public int getIndex() {
        return this._index;
    }

    @Override
    public void encode(ByteBufferPool byteBufferPool, ByteBufferPool.Accumulator accumulator) {
        int size = NBitIntegerEncoder.octetsNeeded((int)5, (long)this._index);
        RetainableByteBuffer retainableByteBuffer = byteBufferPool.acquire(size, false);
        ByteBuffer buffer = retainableByteBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)buffer);
        buffer.put((byte)0);
        NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)5, (long)this._index);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        accumulator.append(retainableByteBuffer);
    }

    public String toString() {
        return String.format("%s@%x[index=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getIndex());
    }
}

