/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.server.internal;

import java.net.URI;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.ee8.websocket.javax.common.UpgradeRequest;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

public class JavaxServerUpgradeRequest
implements UpgradeRequest {
    private final HttpServletRequest _servletRequest;
    private final Principal _userPrincipal;

    public JavaxServerUpgradeRequest(ServerUpgradeRequest upgradeRequest) {
        this._servletRequest = (HttpServletRequest)upgradeRequest.getAttribute("org.eclipse.jetty.websocket.wrappedRequest");
        this._userPrincipal = this._servletRequest.getUserPrincipal();
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public URI getRequestURI() {
        return HttpURI.build((String)this._servletRequest.getRequestURI()).path(URIUtil.addEncodedPaths((String)this._servletRequest.getContextPath(), (String)this.getPathInContext())).query(this._servletRequest.getQueryString()).asImmutable().toURI();
    }

    public String getPathInContext() {
        return URIUtil.encodePath((String)URIUtil.addPaths((String)this._servletRequest.getServletPath(), (String)this._servletRequest.getPathInfo()));
    }
}

