/*
 * Copyright (c) 2024 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.primitive;

import org.eclipse.collections.api.factory.ServiceLoaderUtils;
import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleShortMapFactory;
import org.eclipse.collections.api.factory.map.primitive.MutableDoubleShortMapFactory;

/**
 * DoubleShortMaps is a static utility for creating {@link ImmutableDoubleShortMapFactory}
 * and {@link MutableDoubleShortMapFactory}.
 * This file was automatically generated from template file primitivePrimitiveMapsAPI.stg.
 *
 * @since 11.1.
 */
@SuppressWarnings("ConstantNamingConvention")
@aQute.bnd.annotation.spi.ServiceConsumer(value = ImmutableDoubleShortMapFactory.class)
@aQute.bnd.annotation.spi.ServiceConsumer(value = MutableDoubleShortMapFactory.class)
public final class DoubleShortMaps
{
    public static final ImmutableDoubleShortMapFactory immutable =
            ServiceLoaderUtils.loadServiceClass(ImmutableDoubleShortMapFactory.class);
    public static final MutableDoubleShortMapFactory mutable =
            ServiceLoaderUtils.loadServiceClass(MutableDoubleShortMapFactory.class);

    private DoubleShortMaps()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
